<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;


/* @var $this yii\web\View */
/* @var $model backend\models\Locations */
/* @var $form yii\widgets\ActiveForm */

$this->title = Yii::t('app', 'إستيراد بيانات الطلاب');
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="addmission-form">
<br /><div style="text-align: center;">
<b> لتحميل الملف الأساسي للإستيراد الرجاء الضغط <a href="<?=Yii::$app->homeUrl?>basic.xlsx">هنا</a></b>
</div><br />
<?php $form = ActiveForm::begin(['options'=>['enctype'=>'multipart/form-data']]); ?>

    <!-- <div class="form-group field-addmission-addfile has-success">
        <label class="control-label" for="addmission-addfile">إضافة ملف القبول</label>
        <input type="hidden" name="Addmission[addfile]" value="">
        <input type="file" id="addmission-addfile" name="Addmission[addfile]" aria-invalid="false" accept=".xlx,.xlxs">
        <div class="help-block"></div>
    </div> -->
    <div class="row">
        <div class="col-lg-6">
            <?= $form->field($model,'addfile')->fileInput(['accept' => '.xlx,.xlsx'])->label('إضافة ملف القبول') ?>
        </div>
        <div class="col-lg-6">
            <div class="form-group">
                <?= Html::submitButton('Save', ['class' => 'btn btn-success', 'style'=>'width:100%']) ?>
            </div>
        </div>
    </div>
    <?php ActiveForm::end(); ?>

</div>
<?php if(\Yii::$app->request->post()): ?>
<div class="row">
    <?php $i=1; if(isset($errors) && count($errors)>0) { ?>
        <p><button class="btn btn-primary" type="button" data-bs-toggle="collapse" data-bs-target="#collapseExample" 
            aria-expanded="false" aria-controls="collapseExample"style="width: 100%;">الطلاب</button></p>
        <div class="collapse" id="collapseExample">
            <div class="card card-body">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>م</th>
                            <th>الرقم الجامعي</th>
                            <th>الاسم</th>
                            <th>الرقم الوطني</th>
                            <th>المدرسة الثانوية</th>
                            <th>ملاحظات</th>
                        </tr>
                    </thead>
                    <?php  foreach($errors as $err){?>
                        <tr>
                            <td><?=$i+1 ?></td>
                            <td><?=$err->un_no ?></td>
                            <td><?=$err->student_name_arabic ?></td>
                            <td><?=$err->national_number ?></td>
                            <td><?=$err->high_school ?></td>
                            <td><?php if($err->getErrors()){
                                foreach($err->getErrors() as $e){ echo $e[0].'-'; }
                            }
                            else{echo 'تم الحفظ بنجاح'; } ?></td>
                        </tr>
                    <?php } ?>
                </table>
            </div>
        </div>
    <?php }?>
</div>
<?php endif;?>