<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model frontend\models\student */
/* @var $form yii\widgets\ActiveForm */

$reg_fees = $fine_fees = 0;

$this->title = Yii::t('app', 'التخفيضات');
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="student-discount">

    <?php $form = ActiveForm::begin(); ?>
    
    <div class="student-search">

        <div class="row">
            <div class="col-lg-3">
                <label class="control-label" for="student_un_no">الرقم الجامعي</label>
                <input type="text" class="form-control" name="student_un_no" value="<?=$student->un_no?>" readonly aria-required="true" aria-invalid="false">
            </div>
            <div class="col-lg-3">
                <label class="control-label" for="student_name_arabic">الإسم</label>
                <input type="text" class="form-control" name="student_name_arabic" value="<?=$student->unNo->student_name_arabic?>" readonly aria-required="true" aria-invalid="false">
            </div>
            <div class="col-lg-3">
                <label class="control-label" for="student-year_id">العام الدراسي</label>
                <input type="text" class="form-control" value="<?=$student->studyYear->study_year_name?>" readonly="" aria-required="true" aria-invalid="false">
            </div>
            <div class="col-lg-3">
                <label class="control-label" for="student-curr_id">العملة</label>
                <input type="text" class="form-control" value="<?=$student->unNo->curr->curr_name?>" readonly="" aria-required="true" aria-invalid="false">
            </div>
        </div>
        <div class="row">
            <div class="col-lg-3">
                <label class="control-label" for="student-reg_fees"> رسوم التسجيل </label>
                <input type="text" class="form-control" value="<?=$reg_fees?>" readonly="" aria-required="true" aria-invalid="false">
            </div>
            <div class="col-lg-3">
                <label class="control-label" for="student-fees"> الرسوم الدراسية </label>
                <input type="text" class="form-control" value="<?=$student->unNo->fees?>" readonly="" aria-required="true" aria-invalid="false">
            </div>
            <div class="col-lg-3">
                <label class="control-label" for="student-late_fees">المتأخرات</label>
                <input type="text" class="form-control" value="<?=$student->late_fees?>" readonly="" aria-required="true" aria-invalid="false">
            </div>
            <div class="col-lg-3">
                <label class="control-label" for="student-fine_fees">الغرامة</label>
                <input type="text" class="form-control" value="<?=$fine_fees?>" readonly="" aria-required="true" aria-invalid="false">
            </div>
        </div><br />
    </div>
    <div class="student-search">
        <div class="row">
            <div class="col-lg-6"><?= $form->field($disc, 'disc_type')->dropDownList(
                    \yii\helpers\ArrayHelper::map(\frontend\models\DiscType::find()->where(['hold_id' => 2])->asArray()->all()
                        , 'id', 'name') ,[ 'prompt' => 'اختار نوع التخفيض',
                            'onchange'=>'
                                $.post( "'.Yii::$app->urlManager->createUrl('data/disctypepers?id=').'"+$(this).val()+"", function( data ) {
                                    $( "#studentdisc-disc" ).val(data); });
                                $.post( "'.Yii::$app->urlManager->createUrl('data/disctypefrom?id=').'"+$(this).val()+"", function( data ) {
                                    $( "#studentdisc-disc_from" ).val(data); });
                                $.post( "'.Yii::$app->urlManager->createUrl('data/disctypetype?id=').'"+$(this).val()+"", function( data ) {
                                    $( "#studentdisc-disc_type2" ).html(data); });
                                $.post( "'.Yii::$app->urlManager->createUrl('data/disctypeauth?id=').'"+$(this).val()+"", function( data ) {
                                    $( "#studentdisc-disc_auth" ).val(data); });
                                ' ]);?></div>
            <div class="col-lg-6"><?= $form->field($disc, 'file')->fileInput();?></div>
        </div>
        <div class="row">
            <div class="col-lg-4">
                <div class="form-group field-studentdisc-disc">
                    <label class="control-label" for="studentdisc-disc"id="studentdisc-disc_type2"><br /></label>
                    <input type="text" id="studentdisc-disc" class="form-control" name="StudentDisc[disc]" readonly="">
                </div>
            </div>
            <div class="col-lg-4"><?= $form->field($disc, 'disc_from')->textInput(['readonly'=> true]);?></div>
            <div class="col-lg-4"><?= $form->field($disc, 'disc_auth')->textInput(['readonly'=> true]);?></div>
        </div>
    </div>
    <?= Html::submitButton('حفظ', ['class' => 'btn btn-success', 'style' => 'width: 30%;margin-right: 35%;']) ?>
    <?php ActiveForm::end(); ?>
</div>