<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use common\models\Addmission;
use yii\bootstrap5\Modal;



/* @var $this yii\web\View */
/* @var $searchModel backend\models\AddmissionSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'الطلاب';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="addmission-index">

    <p style="float: left;">
        <?php 
        if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'create')){
            echo Html::a('<span class=" btn btn-success">+</span>', ['addmission/create'], ['class' => 'link-model-lg']);}
        if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'import')){
            echo Html::a('<span class=" btn btn-success">استيراد</span>', ['addmission/import']);}
        ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'summary' => '',
        'options' => ['class' => 'grid-list-view',],
        'layout' => '{items}<nav>{pager}</nav>',
        'pager' => [
            'class' => \yii\bootstrap5\LinkPager::class
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'un_no',
            'student_name_arabic',
            // 'student_name_english',
            // 'national_number',
            [
                'attribute' => 'college_id',
                'value' => 'college.college_name_arabic',
                'filter' => \yii\helpers\ArrayHelper::map(\common\models\College::find()->where(['hold_id' => 2])
                ->asArray()->all(), 'college_id', 'college_name_arabic'),
            ],
            [
                'attribute' => 'department_id',
                'value' => 'department.department_name_arabic',
                'filter' => \yii\helpers\ArrayHelper::map(\common\models\Department::find()->where(['hold_id' => 2])
                ->asArray()->all(), 'department_id', 'department_name_arabic'),
            ],
            [
                'attribute' => 'division_id',
                'value' => 'division.division_name_arabic',
                'filter' => \yii\helpers\ArrayHelper::map(\common\models\Division::find()->where(['hold_id' => 2])
                ->asArray()->all(), 'division_id', 'division_name_arabic'),
            ],
            [
                'attribute' => 'accept_id',
                'value' => 'accept.accept_name',
                'filter' => \yii\helpers\ArrayHelper::map(\common\models\AcceptType::find()->where(['hold_id' => 2])
                ->asArray()->all(), 'accept_id', 'accept_name'),
            ],
            [
                'attribute' => 'accept_year',
                'filter' => \yii\helpers\ArrayHelper::map(\common\models\StudyYear::find()->where(['hold_id' => 2])
                ->asArray()->all(), 'study_year_id', 'study_year_id'),
            ],
            [
                'attribute' => 'gender',
                'value' => 'gender0.name',
                'filter' => \yii\helpers\ArrayHelper::map(\common\models\Gender::find()->where(['hold_id' => 2])
                ->asArray()->all(), 'id', 'name'),
            ],
            [
                'class' => ActionColumn::className(),
                'template' => '{view} {update}',
                'buttons' =>[
                    'view' => function($url, $model){
                        if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'view'))
                        return Html::a('<svg aria-hidden="true" style="display:inline-block;font-size:inherit;
                            height:1em;overflow:visible;vertical-align:-.125em;width:1.125em" viewBox="0 0 576 512">
                            <path fill="currentColor" d="M573 241C518 136 411 64 288 64S58 136 3 241a32 32 0 000 30c55 105 162 
                            177 285 177s230-72 285-177a32 32 0 000-30zM288 400a144 144 0 11144-144 144 144 0 01-144 144zm0-240a95
                            95 0 00-25 4 48 48 0 01-67 67 96 96 0 1092-71z"></path></svg>', $url, ['class' => 'link-model-lg']); else return '';
                    },
                    'update' => function($url, $model){
                        if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'update'))
                        return Html::a('<svg aria-hidden="true" style="display:inline-block;font-size:inherit;
                                height:1em;overflow:visible;vertical-align:-.125em;width:1em"  viewBox="0 0 512 512">
                                <path fill="currentColor" d="M498 142l-46 46c-5 5-13 5-17 0L324 77c-5-5-5-12 0-17l46-46c19-19 49-19 68 
                                    0l60 60c19 19 19 49 0 68zm-214-42L22 362 0 484c-3 16 12 30 28 28l122-22 262-262c5-5 5-13 0-17L301 
                                    100c-4-5-12-5-17 0zM124 340c-5-6-5-14 0-20l154-154c6-5 14-5 20 0s5 14 0 20L144 340c-6 5-14 5-20 0zm-36 
                                    84h48v36l-64 12-32-31 12-65h36v48z"></path></svg>', $url, [ 'class' => 'link-model-lg']); else return '';
                    }
                ],
                'urlCreator' => function ($action, Addmission $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'un_no' => $model->un_no]);
                 }
            ],
        ],
    ]); ?>


</div>
