<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Jobs');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="job-index">
    <p style="float: left;"><?= Html::a('<span class=" btn btn-success">+</span>', ['job/create'], ['class' => 'link-model-md']);?></p>

    <?php Pjax::begin(); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'job_id',
            'job_name',
            // 'cla_job_id',
            'fees1',
            'fees2',
            'hold_id',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\models\Job $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'job_id' => $model->job_id]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
