<?php

/* @var $this \yii\web\View */
/* @var $content string */

\app\assets\AppAsset::register($this);
$this->beginPage(); 
?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <link href="<?=Yii::$app->homeUrl?>oiu.ico" rel="icon" type="image/ico">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= \yii\bootstrap5\Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body class="loading" data-layout-color="light" data-layout-mode="horizontal" data-topbar-color="dark"
    data-menu-position="fixed"style="direction: rtl;">
    <?php $this->beginBody();
        $user_role=null; if (!Yii::$app->user->isGuest&&isset(Yii::$app->user->identity->id)) {
            $user_role=\app\models\UserRols::find()->where(['user_id' => Yii::$app->user->identity->id, 
                'hold_id' => 2])->one();
        }
    ?>
    <!-- Begin page -->
    <div id="wrapper">

        <!-- Topbar Start -->
        <div class="navbar-custom">
            <div class="container-fluid">
                <ul class="list-unstyled topnav-menu float-end mb-0">

                    <li class="d-none d-lg-block">
                        <form class="app-search">
                            <div class="app-search-box dropdown">
                                <div class="input-group">
                                    <input type="search" class="form-control" placeholder="بحث بالرقم الجامعي ..." id="top-search">
                                    <button class="btn input-group-text" type="submit">
                                        <i class="fe-search"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </li>

                    <li class="dropdown d-inline-block d-lg-none">
                        <a class="nav-link dropdown-toggle arrow-none waves-effect waves-light"
                            data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false"
                            aria-expanded="false">
                            <i class="fe-search noti-icon"></i>
                        </a>
                        <div class="dropdown-menu dropdown-lg dropdown-menu-end p-0">
                            <form class="p-3">
                                <input type="text" class="form-control" placeholder="بحث بالرقم الجامعي ..."
                                    aria-label="Recipient's username">
                            </form>
                        </div>
                    </li>

                    <li class="dropdown d-none d-lg-inline-block">
                        <a class="nav-link arrow-none waves-effect waves-light" data-toggle="fullscreen"
                            href="#">
                            <i class="fe-maximize noti-icon"></i>
                        </a>
                    </li>

                    <li class="dropdown notification-list topbar-dropdown">
                        <a class="nav-link dropdown-toggle nav-user me-0 waves-effect waves-light"
                            data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false"
                            aria-expanded="false">
                            <img src="<?=Yii::$app->homeUrl?>img/users/user.jpg" alt="user-image" class="rounded-circle">
                            <span class="pro-user-name ms-1">
                                <?=isset(Yii::$app->user->identity->profile)?
                                    Yii::$app->user->identity->profile->full_name:
                                    Yii::$app->user->identity->username ?>
                            </span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end profile-dropdown ">
                            <!-- item-->
                            <div class="dropdown-header noti-title">
                                <h6 class="text-overflow m-0">مرحباً ! <?=\Yii::$app->user->identity->userrols?\Yii::$app->user->identity->userrols->group->name:''?></h6>
                            </div>

                            <!-- item-->
                            <a href="<?=Yii::$app->homeUrl?>site/editprofile" class="dropdown-item notify-item">
                                <i class="fe-user text-info"></i>
                                <span>حسابي</span>
                            </a>
                            <div class="dropdown-divider"></div>

                            <!-- item-->
                            <?= \yii\bootstrap5\Nav::widget([
                                    'options' => ['class' => 'navbar-nav ml-auto'],
                                    'items' => [\yii\bootstrap5\Html::beginForm(['/site/logout'], 'post', ['class' => 'form-inline'])
                                        . \yii\bootstrap5\Html::submitButton(
                                            'Logout (' . Yii::$app->user->identity->username . ')',
                                            ['class' => 'btn btn-link logout']
                                        ). \yii\bootstrap5\Html::endForm(),],
                                ]);
                            ?>

                        </div>
                    </li>

                </ul>

                <!-- LOGO -->
                <div class="logo-box">
                    <a href="<?=Yii::$app->homeUrl?>" class="logo logo-light text-center">
                        <span class="logo-sm">  
                            <!--<img class="me-2" src="<?=Yii::$app->homeUrl?>img/oiu-light-logo.png" alt="" height="50">    -->
                        </span>
                        <span class="logo-lg"> 
                            <h4 class="text-white d-inline-block text-start">
                                <div class="d-flex"> 
                                    <!--<img class="me-2" src="<?=Yii::$app->homeUrl?>img/oiu-light-logo.png" alt="" height="50"> -->
                                    <div class="mt-1">
                                        <span>جامعة -----</span><br/> 
                                        <small class="text-white-50">النظام الاكاديمي - 
                                            <?=\Yii::$app->user->identity->userrols?\Yii::$app->user->identity->userrols->college->college_name_arabic:''?></small>
                                    </div>
                                </div>
                            </h4> 
                        </span>
                    </a>
                </div>

                <ul class="list-unstyled topnav-menu topnav-menu-left m-0">
                    <li>
                        <button class="button-menu-mobile waves-effect waves-light">
                            <i class="fe-menu"></i>
                        </button>
                    </li>

                    <li>
                        <!-- Mobile menu toggle (Horizontal Layout)-->
                        <a class="navbar-toggle nav-link" data-bs-toggle="collapse"
                            data-bs-target="#topnav-menu-content">
                            <div class="lines">
                                <span></span>
                                <span></span>
                                <span></span>
                            </div>
                        </a>
                        <!-- End mobile menu toggle-->
                    </li>

                    <li class="dropdown d-none d-xl-block">
                        <a class="nav-link waves-effect waves-light" data-bs-toggle="dropdown" href="#"
                            role="button" aria-haspopup="false" aria-expanded="false">
                            <i class="fe-headphones"></i> المساعدة و البلاغات
                            <i class="mdi mdi-chevron-down"></i>
                        </a>
                        <div class="dropdown-menu">
                            <!-- item-->
                            <a href="javascript:void(0);" class="dropdown-item">
                                <i class="fe-file-plus me-1 text-success"></i>
                                <span>تسجيل بلاغ جديد</span>
                            </a>
                            <div class="dropdown-divider"></div>

                            <!-- item-->
                            <a href="javascript:void(0);" class="dropdown-item">
                                <i class="fe-book-open me-1"></i>
                                <span>دليل الاستخدام</span>
                            </a>

                        </div>
                    </li>
                </ul>
                <div class="clearfix"></div>
            </div>
        </div>
        <!-- end Topbar -->
            
        <div class="topnav">
            <div class="container-fluid">
                <?php include('menu.php')?>
            </div> <!-- end container-fluid -->
        </div> <!-- end topnav-->
        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="content">
                <div class="container-fluid" style="min-height: 425px;">
                    <div class="row">
                        <div class="col-10">
                            <div class="page-title-box">
                                <div class="page-title-left">
                                    <!-- <nav aria-label="breadcrumb">
                                        <ol class="breadcrumb">
                                            <li class="breadcrumb-item"><a href="/">الصفحة الرئيسية</a></li>
                                            <li class="breadcrumb-item active" aria-current="page">المهن</li>
                                        </ol>
                                    </nav> -->
                                    <?= \yii\bootstrap5\Breadcrumbs::widget(['homeLink' => ['label' => 'الصفحة الرئيسية','url' => '/',],
                                        'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
                                    ]);?>
                                </div>
                                <!-- <h4 class="page-title"><?=$this->title?></h4> -->
                            </div>
                        </div>
                    </div>
                    
                    <?= \app\widgets\Alert::widget();?>
                    <?= $content; ?>
                </div>
            </div> <!-- content -->

            <!-- Footer Start -->
            <footer class="footer" style="position: fixed;">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-6">
                            <span>جميع الحقوق محفوظة</span>
                            <script>document.write(new Date().getFullYear())</script> &copy;  لـ 
                            <a href="">XpDark</a>
                        </div>
                        <div class="col-md-6">
                            <div class="text-md-end footer-links d-none d-sm-block"> 
                                <a href="javascript:void(0);">الدليل الارشادي</a>
                                <a href="javascript:void(0);">الدعم الفني</a>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- end Footer --> 

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php \yii\bootstrap5\Modal::begin([
            'closeButton' => [
                'label' => '<span aria-hidden="true">&times;</span>',
                'class' => 'close pull-left',
            ],
            'id' => 'activity-modal-lg',
            'size' => 'modal-lg',
        ]);
        echo "<div id='modalContent'></div>";
        \yii\bootstrap5\Modal::end();
        \yii\bootstrap5\Modal::begin([
            'closeButton' => [
                'label' => '<span aria-hidden="true">&times;</span>',
                'class' => 'close pull-left',
            ],
            'id' => 'activity-modal-md',
            'size' => 'modal-md',
        ]);
        echo "<div id='modalContent'></div>";
        \yii\bootstrap5\Modal::end();
        \yii\bootstrap5\Modal::begin([
            'closeButton' => [
                'label' => '<span aria-hidden="true">&times;</span>',
                'class' => 'close pull-left',
            ],
            'id' => 'activity-modal-sm',
            'size' => 'modal-sm',
        ]);
        echo "<div id='modalContent'></div>";
        \yii\bootstrap5\Modal::end();
        ?>
<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage();
