<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Payment */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="payment-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class="row" style="margin: -8px;">
        <div class="col-lg-3"><?= $form->field($model, 'un_no')->textInput(['disabled' => 'disabled']) ?></div>
        <div class="col-lg-3">
            <div class="form-group field-payment-student_name_arabic required">
                <label class="control-label" for="payment-student_name_arabic">إسم الطالب</label>
                <input type="text" id="payment-student_name_arabic" class="form-control" name="Payment[student_name_arabic]" 
                    value="<?=$model->unNo->student_name_arabic?>" aria-required="true" disabled>
            </div>
        </div>
        <div class="col-lg-3"><?= $form->field($model, 'esal_no')->textInput(['maxlength' => true, 'disabled' => 'disabled']) ?></div>
        <div class="col-lg-3"><?= $form->field($model, 'esal_date')->textInput(['disabled' => 'disabled']) ?></div>
    </div>
    <div class="row" style="margin: -8px;">
        <div class="col-lg-3"><?= $form->field($model, 'year_id')->textInput(['disabled' => 'disabled']) ?></div>
        <div class="col-lg-3">
            <div class="form-group field-payment-curr_id required">
                <label class="control-label" for="payment-curr_id">العملة</label>
                <input type="text" id="payment-curr_id" class="form-control" name="Payment[curr_id]" 
                    value="<?=$model->curr->curr_name?>" aria-required="true" disabled>
            </div>
        </div>
        <div class="col-lg-3"><?= $form->field($model, 'late_fees')->textInput(['disabled' => 'disabled']) ?></div>
        <div class="col-lg-3"><?= $form->field($model, 'fine_fees')->textInput(['disabled' => 'disabled']) ?></div>
    </div>
    <div class="row" style="margin: -8px;">
        <div class="col-lg-6"><?= $form->field($model, 'amount')->textInput() ?></div>
        <div class="col-lg-6"><?= $form->field($model, 'notes')->textInput(['maxlength' => true]) ?></div>
    </div>
    <?= Html::submitButton('حفظ', ['class' => 'btn btn-success', 'style' => 'width: 30%;margin-right: 35%;']) ?>

    <?php ActiveForm::end(); ?>

</div>
