<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\student */
/* @var $form yii\widgets\ActiveForm */

$this->title = 'تعديل بيانات الطلاب';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="student-form">

    <?php $form = ActiveForm::begin(); ?>
    
    <!-- Basic Information -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title"><i class="ti-id-badge"></i> | البيانات الاساسية
                    </h4>
                    <p class="sub-header">
                        <small>تحتوي هذه الحقول علي البيانات الاساسية للطالب.</small>
                    </p>

                    <div class="row">
                        <div class="col-lg-12">
                            <!-- Basic Information -->
                            <div>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <label class="form-label">الصورة الشخصية</label>
                                        <img src="<?=isset($student->images)?'http://196.202.149.24/api/web/'.$student->images:'/img/users/user.jpg'?>" 
                                            class="img-fluid rounded img-thumbnail"style="min-width: 100%;">
                                        <div class="text-info mt-2">
                                            <small>يمكن للطالب فقط تغير صورته الشخصية من خلال الموقع
                                                الالكتروني</small>
                                            <br />
                                            <small>المقاسات <code>250px X 250px</code></small>
                                        </div>
                                    </div>
                                    <div class="col-sm-9">
                                        <div class="mb-1"><b>الاسم الطالب مفصل باللغة <span class="text-success">العربية</span></b> <i
                                                class="fe-corner-left-down text-info"></i></div>
                                        <div class="row">
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-f_name_ar">
                                                    <?= $form->field($student, 'f_name_ar')->textInput(['disabled'=>true])->label('الأول') ?>
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-s_name_ar">
                                                    <?= $form->field($student, 's_name_ar')->textInput(['disabled'=>true])->label('الثاني') ?>
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-t_name_ar">
                                                    <?= $form->field($student, 't_name_ar')->textInput(['disabled'=>true])->label('الثالث') ?>
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-l_name_ar">
                                                    <?= $form->field($student, 'l_name_ar')->textInput(['disabled'=>true])->label('الأخير') ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="mb-1"><b>الاسم الطالب مفصل باللغة <span
                                                    class="text-pink">الانجليزية</span></b> <i
                                                class="fe-corner-left-down text-info"></i></div>
                                        <div class="row">
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-l_name_en">
                                                    <?= $form->field($student, 'l_name_en')->textInput()->label('الأخير') ?>
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-t_name_en">
                                                    <?= $form->field($student, 't_name_en')->textInput()->label('الثالث') ?>
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-s_name_en">
                                                    <?= $form->field($student, 's_name_en')->textInput()->label('الثاني') ?>
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-f_name_en">
                                                    <?= $form->field($student, 'f_name_en')->textInput()->label('الأول') ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-nationality_id">
                                                    <?= $form->field($student, 'nationality_id')->dropDownList(
                                                        \yii\helpers\ArrayHelper::map(\app\models\Nationalty::find()->where(['hold_id' => 2])
                                                            ->asArray()->all(), 'nat_id', 'nat_name')) ?>
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-national_number">
                                                    <?= $form->field($student, 'national_number')->textInput(['placeholder'=>'140-0000-0000-0000', 'disabled'=>true]) ?>
                                                    <div class="text-info"><small>اكتب الرقم الوطني بدون فواصل</small></div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-student_basic_phone">
                                                    <?= $form->field($student, 'student_basic_phone')->textInput(['maxlength' => true, 'placeholder'=>'091-0000-0000'])?>
                                                    <div class="text-info"><small>تاكد ان الرقم يعمل</small></div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3">
                                                <div class="mb-3 field-addmission-student_second_phone">
                                                    <?= $form->field($student, 'student_second_phone')->textInput(['maxlength' => true, 'placeholder'=>'091-0000-0000'])?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">                                                        
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-student_email">
                                            <?= $form->field($student, 'student_email')->textInput(['placeholder'=>'student@gmail.com']) ?>
                                            <div class="text-info"><small>مهم جداً لوصول اشعارات التسجيل و غيرها</small></div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-birthdate">
                                            <?php //echo $form->field($student, 'birthdate')->widget(\kartik\date\DatePicker::classname(), [
                                            //     'options' => ['placeholder' => 'Enter birth date ...'], 'value' => '01/29/2014',
                                            //     'pluginOptions' => ['autoclose' => true, 'format' => 'mm/dd/yyyy'],
                                            //     'pickerIcon' => '<i class="fas fa-calendar-alt text-primary"></i>',
                                            //     'removeIcon' => '<i class="fas fa-trash text-danger"></i>',
                                            //     'type' => \kartik\date\DatePicker::TYPE_COMPONENT_APPEND,
                                            // ]);?>
                                            <label class="form-label"
                                                for="addmission-birthdate">تاريخ ميلاد
                                            </label>
                                            <input type="date" id="addmission-birthdate"
                                                class="form-control" name="Addmission[birthdate]" value="2022-01-01">
                                            <div class="help-block"></div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-place_birth">
                                            <?= $form->field($student, 'place_birth')->dropDownList(
                                                \yii\helpers\ArrayHelper::map(\app\models\State::find()->where(['hold_id' => 2])
                                                    ->asArray()->all(), 'state_id', 'state_name')) ?>
                                            <div class="text-info"><small>للسودانيين فقط</small></div>
                                        </div>
                                    </div>                                                        
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-high_school">
                                            <?= $form->field($student, 'high_school')->textInput() ?>
                                            <div class="text-info"><small>المدرسة التي امتحن منها للشهادة الثانوية</small></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-origin_state_id">
                                            <?= $form->field($student, 'origin_state_id')->dropDownList(
                                                \yii\helpers\ArrayHelper::map(\app\models\State::find()->where(['hold_id' => 2])
                                                    ->asArray()->all(), 'state_id', 'state_name')) ?>
                                            <div class="text-info"><small>مسقط الراس</small></div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-origin_student_address">
                                            <?= $form->field($student, 'origin_student_address')->textInput() ?>
                                            <div class="text-info"><small>بهذه الصيغة ( المحلية - الحي - المربع - معلم بارز )</small></div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-current_state_id">
                                            <?= $form->field($student, 'current_state_id')->dropDownList(
                                                \yii\helpers\ArrayHelper::map(\app\models\State::find()->where(['hold_id' => 2])
                                                    ->asArray()->all(), 'state_id', 'state_name')) ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-current_student_address">
                                            <?= $form->field($student, 'current_student_address')->textInput() ?>
                                            <div class="text-info"><small>بهذه الصيغة ( المحلية - الحي - المربع - معلم بارز )</small></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    
                                    <div class="col-lg-4">
                                        <div class="mb-3 field-addmission-gender">
                                            <div><label class="form-label" for="addmission-gender">النوع</label></div>
                                            <div class="row mt-1">
                                                <div class="col">
                                                    <div class="form-check form-check-warning">
                                                        <input type="radio" id="Addmission[gender]1" name="Addmission[gender]" class="form-check-input">
                                                        <label class="form-check-label" for="Addmission[gender]1"><i class="icon-symbol-male text-warning"></i>  ذكر</label>
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="form-check form-check-pink">
                                                        <input type="radio" id="Addmission[gender]2" name="Addmission[gender]" class="form-check-input">
                                                        <label class="form-check-label" for="Addmission[gender]2"><i class="icon-symble-female text-pink"></i> أنثى</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="help-block"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Parent Information -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title"><i class="ti-user"></i> | بيانات ولي الأمر</h4>
                    <p class="sub-header"><small>هذه القسم لبيانات ولي امر الطالب.</small></p>
                    <div class="row">
                        <div class="col-lg-12">
                            <!-- Parent Information -->
                            <div>
                                <div class="student-search">
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <div class="mb-3 field-addmission-parent_name">
                                                <?= $form->field($student, 'parent_name')->textInput() ?>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="mb-3 field-addmission-parent_basic_phone">
                                                <?= $form->field($student, 'parent_basic_phone')->textInput() ?>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="mb-3 field-addmission-parent_second_phone">
                                                <?= $form->field($student, 'parent_second_phone')->textInput() ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <div class="mb-3 field-addmission-parent_job_id">
                                                <?= $form->field($student, 'parent_job_id')->dropDownList(
                                                    \yii\helpers\ArrayHelper::map(\app\models\Job::find()->where(['hold_id' => 2])
                                                        ->asArray()->all(), 'job_id', 'job_name')) ?>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="mb-3 field-addmission-parent_address">
                                                <?= $form->field($student, 'parent_address')->textInput() ?>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="mb-3 field-addmission-parent_job_address">
                                                <?= $form->field($student, 'parent_job_address')->textInput() ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?= Html::submitButton('حفظ', ['class' => 'btn btn-success', 'style' => 'width: 30%;margin-right: 35%;']) ?>

    <?php ActiveForm::end(); ?>

</div>