<?php

use yii\helpers\ArrayHelper;
use yii\widgets\ListView;
use yii\helpers\Html;
use yii\widgets\Pjax;
use yii\helpers\Url;
/* @var $this yii\web\View */
/* @var $searchModel app\models\StudentSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'المعاينات');
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="student-index">

    <?= $this->render('_search2', ['model' => $searchModel]); ?>
    
    <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <table class="table table-centered table-nowrap table-striped table-hover"id="products-datatable">
                        <thead>
                            <tr>
                                <th>الاسم</th>
                                <th>الرقم الجامعي</th>
                                <th>نوع القبول</th>
                                <th>الكلية</th>
                                <th>رسوم التسجيل</th>
                                <th>الرسوم الدراسية</th>
                                <td></td>
                            </tr>
                        </thead>
                    <?= ListView::widget([
                        'dataProvider' => $dataProvider,
                        // 'filterModel' => $searchModel,
                        // 'summary' => '',
                        'options' => ['class' => 'grid-list-view',],
                        'layout' => '{items}</table><nav>{summary}{pager}</nav>',
                        'pager' => [
                            'class' => \yii\bootstrap5\LinkPager::class,
                            'firstPageLabel' => '<i class="bi bi-chevron-bar-right"></i>',
                            'lastPageLabel' => '<i class="bi bi-chevron-bar-left"></i>',
                        ],
                        'itemView' => function ($data, $key, $index, $widget) { $home= Yii::$app->homeUrl; include('grid.php'); },
                    ]);?>
                </div>
            </div>
        </div>
    </div>

</div>
