<?php

use app\models\Department;
use yii\helpers\ArrayHelper;
use app\models\StudyYear;
use yii\widgets\ActiveForm;
use app\models\College;
use app\models\Classes;
use app\models\Gender;
use app\models\Report;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $form yii\widgets\ActiveForm */
$this->title = Yii::t('app', 'التقارير');
$this->params['breadcrumbs'][] = $this->title;
$userrole = \Yii::$app->user->identity->userrols;
$college = College::find()->where('college_id!=0')->asArray()->all();
$departments = [];
$classes = \app\models\Classes::find()->where(['hold_id' => 2])->asArray()->all();
$gender = Gender::find()->where('id!=0')->asArray()->all();
if($userrole){ 
    if($userrole->college_id!=0){
        $college = College::find()->where(['college_id' => $userrole->college_id])->asArray()->all();
        $departments = \app\models\Department::find()->where(['hold_id' => 2, 
            'college_id' => $userrole->college_id])->asArray()->all();
        $classes = \app\models\Classes::find()->where(['hold_id' => 2])->andWhere([
            '<=', 'class_id', $userrole->college->final_class])->asArray()->all();    
    } 
    if($userrole->gender_id!=0)$gender = Gender::find()->where(['id' => $userrole->gender_id])->asArray()->all();
}
?>
<div class="report-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class="student-search">
        <div class="row" style="margin: -8px;">
            <div class="col-lg-4"><?= $form->field($model, 'report_id')->dropDownList(
                ArrayHelper::map(Report::find()->where(['user_group' => 0])->asArray()->all(), 'action_name', 'rep_name'))->label("نوع التقرير")?></div>
            <div class="col-lg-4"><?php  if(null!==$userrole && $userrole->college_id!=0){
                echo $form->field($model, 'coll_id')->dropDownList(
                    ArrayHelper::map($college, 'college_id', 'college_name_arabic'), [ 'onchange'=>'
                            $.post( "'.Yii::$app->urlManager->createUrl('data/department?coll_id=').'"+$(this).val()+"", function( data ) {
                            $( "select#dynamicmodel-dep_id" ).html( data ); });' ])->label("الكلية");
            }else{ echo $form->field($model, 'coll_id')->dropDownList(
                ArrayHelper::map($college, 'college_id', 'college_name_arabic'), [
                    'prompt' => 'اختار الكلية', 'onchange'=>'
                        $.post( "'.Yii::$app->urlManager->createUrl('data/department?coll_id=').'"+$(this).val()+"", function( data ) {
                        $( "select#dynamicmodel-dep_id" ).html( data ); });' ])->label("الكلية");
                }
            ?></div>
            <div class="col-lg-4"><?= $form->field($model, 'dep_id')->dropDownList(
                ArrayHelper::map($departments, 'department_id', 'department_name_arabic'))->label("التخصص")?></div>
            <div class="col-lg-4"><?= $form->field($model, 'gender')->dropDownList(
                ArrayHelper::map($gender, 'id', 'name'))->label("الجنس")?></div>
            <div class="col-lg-4"><?= $form->field($model, 'year_id')->dropDownList(
                ArrayHelper::map(StudyYear::find()->where(['active' => 2, 'hold_id' => 2])->asArray()->all(), 'study_year_id', 'study_year_name'))->label("العام الدراسي")?></div>
            <div class="col-lg-4"><?= $form->field($model, 'cla_id')->dropDownList(
                ArrayHelper::map(Classes::find()->asArray()->all(), 'class_id', 'class_name_arabic'))->label("الفرقة")?></div>
        </div>
    </div>
    <?= Html::submitButton('بحث', ['class' => 'btn btn-success', 'style' => 'width: 30%;margin-right: 35%;']) ?>

    <?php ActiveForm::end(); ?>
</div>