<?php

use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\StudentSearch */
/* @var $form yii\widgets\ActiveForm */

$this->title = Yii::t('app', 'نقل الفرق');
$this->params['breadcrumbs'][] = $this->title;

$prevYear = \app\models\StudyYear::find()->where(['active' => 2, 'hold_id' => 2])->asArray()->all();
$activeYear = \app\models\StudyYear::find()->where(['open_acc' => 2, 'hold_id' => 2])->asArray()->all();

$userrole = \Yii::$app->user->identity->userrols;
$acdmic_status = \app\models\AcademicStatus::find()->where(['hold_id' => 2])->all();
$gender = \app\models\Gender::find()->where('id!=0')->asArray()->all();
$departments = \app\models\Department::find()->where(['hold_id' => 2])->asArray()->all();
$classes = \app\models\Classes::find()->where(['hold_id' => 2])->asArray()->all();
if($activeYear){ 
    if($userrole){
        $departments = \app\models\Department::find()->where(['hold_id' => 2, 
            'college_id' => $userrole->college_id])->asArray()->all();
        $classes = \app\models\Classes::find()->where(['hold_id' => 2])->andWhere([
            '<=', 'class_id', $userrole->college->final_class])->asArray()->all();
        if($userrole->gender_id!=0)
            $gender = \app\models\Gender::find()->where(['id' => $userrole->gender_id])->asArray()->all();
    }
?>

<div class="row">
    <div class="col-12">
        <?php if($msg){?>
        <!-- Alert -->
        <div class="alert alert-success" role="alert">                                
            <div class="d-flex">
                <div><i class="ti-face-smile me-2 font-28"></i></div>
                <div><?=$msg?></div>
            </div>
        </div>
        <!-- End Alert -->
        <?php }?>
        <div class="card">
            <div class="card-body">
                <h5 class="card-title mb-1"><i class="icon-layers"></i> | البيانات الاولية</h5>                                        
                <p class="text-muted"><small>هذه الخيارات مخصصة لنقل الفرق من عام دراسي الي عام دراسي جديد</small></p>

                <?php $form = ActiveForm::begin(['action' => ['move'],'method' => 'get']); ?>
                    <div class="row">
                        <div class="col">
                            <?= $form->field($model, 'year_id_from')->dropDownList(ArrayHelper::map($prevYear, 'study_year_id', 'study_year_name'))
                                ->label('<span class="text-blue">من</span> العام الدراسي <span class="text-danger ti-flag"></span>')?>
                        </div>
                        <div class="col">
                            <?= $form->field($model, 'year_id_to')->dropDownList(ArrayHelper::map($activeYear, 'study_year_id', 'study_year_name'))
                                ->label('<span class="text-pink">الي</span> العام الدراسي  <span class="text-danger ti-flag"></span>')?>
                        </div>
                        <div class="col">
                            <?= $form->field($model, 'department_id')->dropDownList(ArrayHelper::map($departments, 'department_id', 'department_name_arabic'))
                                ->label('القسم  <span class="text-danger ti-flag"></span>')?>
                        </div>
                        <div class="col">
                            <?= $form->field($model, 'class_id')->dropDownList(ArrayHelper::map($classes, 'class_id', 'class_name_arabic'))
                                ->label('الفرقة  <span class="text-danger ti-flag"></span>')?>
                        </div>
                        <div class="col">
                            <?= $form->field($model, 'gender_id')->dropDownList(ArrayHelper::map($gender, 'id', 'name'))
                                ->label('الجنس  <span class="text-danger ti-flag"></span>')?>
                        </div>
                        <div class="col text-end">
                            <label class="form-label">&nbsp;</label><br/>
                            <button class="btn btn-info"><i class="ti-search"></i> | عرض</button>
                        </div>
                    </div>
                <?php ActiveForm::end(); ?>
                <div class="mt-4">
                    <div class="d-flex align-items-center">
                        <div class="pe-2">
                            <span class="font-28 text-info"><i class="icon-info"></i></span>
                        </div>
                        <div class="small text-info">
                            <span>جميع الحقول المشار اليها بالرمز (<span class="text-danger ti-flag"></span>) إجبارية</span><br/>
                        </div>                                   
                    </div>        
                </div>
            </div>
        </div> <!-- end card -->
    </div><!-- end col-->
</div>
<?php if($student){?>
<div class="row">
    <div class="col-12">
        <?php $form = ActiveForm::begin(['action' => ['move'],'method' => 'post']); ?>
        <?= $form->field($model, 'year_id_from')->hiddenInput()->label(false); ?>
        <?= $form->field($model, 'year_id_to')->hiddenInput()->label(false); ?>
        <?= $form->field($model, 'department_id')->hiddenInput()->label(false); ?>
        <?= $form->field($model, 'class_id')->hiddenInput()->label(false); ?>
        <?= $form->field($model, 'gender_id')->hiddenInput()->label(false); ?>
        <div class="card">
            <div class="card-body">
                <h5 class="card-title mb-1"><i class="icon-people"></i> | الطلاب</h5>                                    
                <p class="text-muted"><small>الطلاب المطلوب نقلهم من سنة <b><?=$model->year_id_from?></b> الي سنة <b><?=$model->year_id_to?></b></small></p>
                <div class="">
                    <table class="table table-borderless table-hover">
                        <thead class="table-light">
                            <tr>
                                <th style="width: 20px;"></th>
                                <th style="width: 20px;"></th>
                                <th>الاسم</th>
                                <th>الرقم الجامعي</th>
                                <th>الموقف الاكاديمي السابق</th> 
                                <th>الموقف الجديد <span class="text-danger ti-flag"></span></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php for($i=0;$i<count($student);$i++){?>
                                <tr class="<?=$student[$i]['next_id']!=0?'bg-soft-success':''?>">
                                    <td>
                                        <div class=""><?=$student[$i]['next_id']!=0?                                     
                                            '<h3 class="text-success"><b><i class="fe-check-square"></i></b></h3>':
                                            '<h3 class="text-muted"><b><i class="fe-square"></i></b></h3>';?>
                                        </div>
                                    </td> 
                                    <td><?=$i+1?></td>
                                    <td class="table-user">
                                        <div class="d-flex"> 
                                        <img src="<?=isset($student[$i]['images'])?'http://196.202.149.24/api/web/'.$student[$i]['images']:'/img/users/user.jpg'?>" 
                                            class="avatar-lg rounded-circle img-thumbnail">
                                            <?=Html::a('<span style="font-weight: bold;">'.$student[$i]['student_name_arabic'].'</span>', 
                                                ['student/view', 'un_no' => $student[$i]['un_no']], [ 
                                                'title' => $student[$i]['student_name_arabic'].' ('.$student[$i]['id'].')', 'class' => 'text-dark']) ?>
                                        </div>  
                                    </td>
                                    <td><?=$student[$i]['un_no']?></td> 
                                    <td>
                                        <b><?=$student[$i]['academic_status_name']?></b><br/>
                                        <span class="badge bg-soft-success text-success">
                                            <?=$student[$i]['is_reg']==1?'غير مسجل':($student[$i]['status_id']==5?'مجمد':'مسجل')?>
                                        </span>
                                    </td>
                                    <td class="w-25">
                                        <div class="form-group field-student-un_no">
                                            <input type="hidden" id="student-un_no" class="form-control" name="student[][un_no]" value="<?=$student[$i]['un_no']?>">
                                        </div>
                                        <div class="form-group field-student-next_id">
                                            <input type="hidden" id="student-next_id" class="form-control" name="student[][next_id]" value="<?=$student[$i]['next_id']?>">
                                        </div>
                                        <div class="form-group field-student-pas required has-success">
                                            <select id="student-pas" class="form-control" name="student[][pas]" aria-required="true" aria-invalid="false">
                                                <?php foreach($acdmic_status as $acd){?><option value="<?=$acd->academic_status_id?>"><?=$acd->academic_status_name?></option><?php }?>
                                            </select>
                                        </div>
                                    </td> 
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                
                <div class="mt-4">
                    <div class="d-flex align-items-center">
                        <div class="pe-2">
                            <span class="font-28 text-info"><i class="icon-info"></i></span>
                        </div>
                        <div class="small text-info">
                            <span>اللون الاخضر (<b><i class="fe-check-square text-success"></i></b>) يعني ان الطالب تم نقله مسبقا.</span>                                                
                        </div>                                   
                    </div>        
                </div>                                   

            </div> <!-- end card-body-->
        </div> <!-- end card-->
        <!-- Buttun -->
        
        <div class="card">
            <div class="card-body">
                <button class="btn btn-info float-end">
                    <div class="d-flex align-items-center">
                        <div class="pe-2 font-18"><i class="icon-rocket"></i> </div>
                        <div>
                            <b>نقل الطلاب</b><br/>
                            <small>أضغط نقل بعد المراجعة</small>
                        </div>
                    </div>
                </button>
                <div class="d-flex align-items-center">
                    <div class="pe-2">
                        <span class="font-28 text-info"><i class="icon-info"></i></span>
                    </div>
                    <div>
                        <small class="text-info">قم بتحديد جميع الطلاب المطلوب نقلهم من مستوي الي اخر.</small><br/>
                        <small class="text-info"><b>رجاءاً</b> ,, حدد البيانات بدقة بالغة لتقليل نسبة الخطأ.</small><br/>
                        <small class="text-info">لابد من المراجعة جيدا و التاكيد من صحة البيانات المدخلة قبل الضغط علي النقل.</small>
                    </div>                                   
                </div>                                   
            </div>
        </div>
        <?php ActiveForm::end();?>
    </div> <!-- end col -->
</div>
<!-- end row -->
<?php } } ?>