<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'إدارة العام الدراسي');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="study-year-index">

    <p>
        <?= Html::a(Yii::t('app', 'Create Study Year'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>


    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'study_year_id',
            'study_year_name',
            'active',
            'open_acc',
            'hold_id',
            [
                'class' => ActionColumn::className(),
                'template' => '{update}',
                'urlCreator' => function ($action, \app\models\StudyYear $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'study_year_id' => $model->study_year_id]);
                 }
            ],
        ],
    ]); ?>


</div>
