<?php

use common\models\Controllers;
use common\models\Department;
use common\models\HoldStatus;
use yii\helpers\ArrayHelper;
use common\models\UserGroup;
use yii\widgets\ActiveForm;
use common\models\College;
use common\models\Actions;
use common\models\Gender;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model common\models\User */
/* @var $form yii\widgets\ActiveForm */

$user_rols = \frontend\models\UserRols::find()->where(['user_id' => 
    Yii::$app->user->identity->id, 'hold_id' => 2])->one();
if($user_rols){
    if($user_rols->group_id == 3){ $user_group = UserGroup::find()->where(['or', 
        ['group_id' => 13], ['group_id' => 14], ['group_id' => 17], ['group_id' => 18]])->asArray()->all();}
    else $user_group = UserGroup::find()->where('id>1')->asArray()->all();
} else $user_group = UserGroup::find()->where('id>1')->asArray()->all();
?>

<div class="user-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class="student-search">
        <div class="row">
            <div class="col-lg-4"><?= $form->field($model, 'username')->textInput(['maxlength' => true]) ?></div>
            <div class="col-lg-4"><?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?></div>
            <div class="col-lg-4"><?= $form->field($model, 'hold_id')->dropDownList(
                ArrayHelper::map(HoldStatus::find()->asArray()->all(), 'id', 'name'))?></div>
        </div>
        <div class="row">
            <div class="col-lg-3"><?= $form->field($userrole, 'college_id')->dropDownList(
                ArrayHelper::map(College::find()->asArray()->all(), 'college_id', 'college_name_arabic'), [ 
                    // 'prompt' => 'اختار الكلية', 
                    'onchange'=>'
                        $.post( "'.Yii::$app->urlManager->createUrl('data/department?coll_id=').'"+$(this).val()+"", function( data ) {
                        $( "select#userrols-department_id" ).html( data ); });' ])?></div>
            <div class="col-lg-3"><?= $form->field($userrole, 'department_id')->dropDownList(
                ArrayHelper::map(Department::find()->asArray()->all(), 'department_id', 'department_name_arabic'))?></div>
            <div class="col-lg-3"><?= $form->field($userrole, 'gender_id')->dropDownList(
                ArrayHelper::map(Gender::find()->asArray()->all(), 'id', 'name'))?></div>
            <div class="col-lg-3"><?= $form->field($userrole, 'group_id')->dropDownList(
                ArrayHelper::map($user_group, 'id', 'name'))?></div>
        </div>
    </div>
    <?php if($grouproles){ ?>
        <div class="student-search">
            <div class="col-lg-12"style="text-align: center;">صلاحيات المجموعة - <?=$grouproles[0]->group->name?></div>
            <div class="row"><?php foreach($grouproles as $grouprole){?>
                <div class="col-lg-4">
                    <input type="text" value="<?=$grouprole->controller0->name.'/'.$grouprole->action0->name?>" 
                        class="form-control"aria-invalid="true" disabled>
                </div>
            <?php } ?></div>
        </div>
    <?php } if($user_role){?>
        <div class="student-search">
            <?php 
                $form = ActiveForm::begin(['id' => 'dynamic-form']);
                \wbraganca\dynamicform\DynamicFormWidget::begin([
                    'widgetContainer' => 'dynamicform_wrapper', // required: only alphanumeric characters plus "_" [A-Za-z0-9_]
                    'widgetBody' => '.container-items', // required: css class selector
                    'widgetItem' => '.item', // required: css class
                    'limit' => 4, // the maximum times, an element can be cloned (default 999)
                    'min' => 0, // 0 or 1 (default 1)
                    'insertButton' => '.add-item', // css class
                    'deleteButton' => '.remove-item', // css class
                    'model' => $user_role[0],
                    'formId' => 'dynamic-form',
                    'formFields' => [
                        // 'user_role_id',
                        'controller',
                        'action',
                    ],
                ]); 
            ?>
            <div class="panel panel-default">
                <div class="panel-heading"><h4 style="text-align: center;">
                    صلاحيات الفرد - <?=$user_role[0]->userRole->username?></h4>
                    <div class="pull-right"style="float: left;margin-left: 10px;">
                        <button type="button" class="add-item btn btn-success btn-xs">+</button>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="container-items"><!-- widgetContainer -->
                        <?php foreach ($user_role as $i => $role): ?>
                            <div class="item panel panel-default"><!-- widgetBody -->
                                <div class="panel-heading">
                                    <div class="pull-right"style="float: left;margin-left: 10px;">
                                        <!-- <button type="button" class="add-item btn btn-success btn-xs">+</button> -->
                                        <button type="button" class="remove-item btn btn-danger btn-xs">-</button>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>
                                <div class="panel-body"style="margin: 0px 10px;">
                                    <?=Html::activeHiddenInput($role, "[{$i}]id");?>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <?= $form->field($role, "[{$i}]controller")->dropDownList(
                                                ArrayHelper::map(Controllers::find()->asArray()->all(), 'id', 'name'))?>
                                        </div>
                                        <div class="col-sm-6">
                                            <?= $form->field($role, "[{$i}]action")->dropDownList(
                                                ArrayHelper::map(Actions::find()->asArray()->all(), 'id', 'name')) ?>
                                        </div>
                                    </div><!-- .row -->
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <?php \wbraganca\dynamicform\DynamicFormWidget::end(); ?>
        </div>
        <?php } ?>
    <div class="form-group">
        <?= Html::submitButton('حفظ', ['class' => 'btn btn-success', 'style' => 'width: 30%;margin-right: 35%;']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
