<?php

/* @var $this yii\web\View */
/* @var $form yii\bootstrap5\ActiveForm */
/* @var $model \frontend\models\SignupForm */

use yii\bootstrap5\Html;
use yii\bootstrap5\ActiveForm;

$this->title = 'Signup';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-signup">
    <p>Please fill out the following fields:</p>
    
    <?php $form = ActiveForm::begin(['id' => 'form-signup']); ?>
    <div class="row">
        <div class="col-lg-3">
            <?= $form->field($model, 'username')->textInput(['autofocus' => true])->label('اسم المستخدم');?>
        </div>
        <div class="col-lg-3">
            <?= $form->field($model, 'email')->label('البريد الإلكتروني');?>
        </div>
        <div class="col-lg-3">
            <?= $form->field($model, 'password')->passwordInput()->label('كلمة المرور');?>
        </div>
        <div class="col-lg-3">
            <?= $form->field($model, 'repeatepassword')->passwordInput()->label('تكرار كلمة المرور');?>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-3"><?= $form->field($userrole, 'college_id')->dropDownList(
            \yii\helpers\ArrayHelper::map(\app\models\College::find()->asArray()->all(), 'college_id', 'college_name_arabic'), [ 
                // 'prompt' => 'اختار الكلية', 
                'onchange'=>'
                    $.post( "'.Yii::$app->urlManager->createUrl('data/department?coll_id=').'"+$(this).val()+"", function( data ) {
                    $( "select#userrols-department_id" ).html( data ); });' ])?></div>
        <div class="col-lg-3"><?= $form->field($userrole, 'department_id')->dropDownList(
            \yii\helpers\ArrayHelper::map(\app\models\Department::find()->where('department_id=0')->asArray()->all(), 'department_id', 'department_name_arabic'))?></div>
        <div class="col-lg-3"><?= $form->field($userrole, 'gender_id')->dropDownList(
            \yii\helpers\ArrayHelper::map(\app\models\Gender::find()->asArray()->all(), 'id', 'name'))?></div>
        <div class="col-lg-3"><?= $form->field($userrole, 'group_id')->dropDownList(
            \yii\helpers\ArrayHelper::map(\app\models\UserGroup::find()->where('id>1')->asArray()->all(), 'id', 'name'))?></div>
    </div>
    <div class="form-group">
        <?= Html::submitButton('حفظ', ['class' => 'btn btn-primary', 'name' => 'signup-button']) ?>
    </div>
    <?php ActiveForm::end(); ?>
</div>