<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel backend\models\UserGroupSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'المجموعات');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="user-group-index">

    <?php Pjax::begin(); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'summary' => '',
        'options' => ['class' => 'grid-list-view',],
        'layout' => '{items}<nav>{pager}</nav>',
        'pager' => [
            'options' => [
                'tag' => 'ul',
                'class' => 'pagination justify-content-center',
                'id' => 'pager-container',
            ],
            //Current Active option value
		    'activePageCssClass' => 'page-active',
            'linkOptions' => ['class' => 'page-link'],
            'pageCssClass' => ['class' => 'page-item'],

            'firstPageLabel' => 'الأول',
            'lastPageLabel' => 'الأخير',
            'prevPageLabel' => 'السابق',
            'nextPageLabel' => 'التالي',
            'maxButtonCount' => 3,
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'id',
            'name',
            'name_en',
            // 'hold_id',
            [
                'class' => ActionColumn::className(),
                'template' => '{update} {updatestatus}',
                'buttons' =>[
                    'updatestatus' => function($url, $model){
                        if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'updatestatus')){
                            if($model->hold_id==1)
                                return Html::a('<li class="fa fa-lock-open"></li>', $url);
                            else return Html::a('<li class="fa fa-unlock"></li>', $url);
                        }
                    },
                    'update' => function($url, $model){
                        if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'update-user-group')){
                            return Html::a('<i class="fas fa-pencil-alt"></i>', $url);}
                    }
                ],
                'urlCreator' => function ($action, \app\models\UserGroup $model, $key, $index, $column) {
                    // return Url::toRoute([$action, 'id' => $model->id]);
                    if ($action === 'update') {
                        $url = Url::to(['user/update-user-group', 'id' => $model->id]);
                        return $url;
                    }if ($action === 'updatestatus') {
                        $url = Url::to(['user/update-group-status', 'id' => $model->id]);
                        return $url;
                    }
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
