<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
/* @var $this yii\web\View */
/* @var $searchModel app\models\StudentSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'إجراء لجنة المعاينة');
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="student-form">

    <?php $form = ActiveForm::begin(); ?>

    <!-- Acceptance Information -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title"><i class="icon-like"></i> | بيانات القبول</h4>
                    <p class="sub-header"><small>هذا القسم لبيانات القبول القادم من الوزارة.</small></p>
                    <div class="row">
                        <div class="col-lg-12">
                            <div>
                                <div class="row" >
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-college_id">
                                            <?= $form->field($student, 'college_id')->dropDownList(
                                                \yii\helpers\ArrayHelper::map(\app\models\College::find()->where(['hold_id' => 2])
                                                    ->asArray()->all(), 'college_id', 'college_name_arabic'), ['disabled'=>true]) ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-department_id">
                                            <?= $form->field($student, 'department_id')->dropDownList(
                                                \yii\helpers\ArrayHelper::map(\app\models\Department::find()->where(['hold_id' => 2])
                                                    ->asArray()->all(), 'department_id', 'department_name_arabic'), ['disabled'=>true]) ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-division_id">
                                            <?= $form->field($student, 'division_id')->dropDownList(
                                                \yii\helpers\ArrayHelper::map(\app\models\Division::find()->where(['hold_id' => 2])
                                                    ->asArray()->all(), 'division_id', 'division_name_arabic'), ['disabled'=>true]) ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-accept_id">
                                            <?= $form->field($student, 'accept_id')->dropDownList(
                                                \yii\helpers\ArrayHelper::map(\app\models\AcceptType::find()->where(['hold_id' => 2])
                                                    ->asArray()->all(), 'accept_id', 'accept_name'), ['disabled'=>true]) ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="row" style="margin: -8px;">
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-accept_year">
                                            <?= $form->field($student, 'accept_year')->dropDownList(
                                                \yii\helpers\ArrayHelper::map(\app\models\StudyYear::find()->where(['hold_id' => 2])
                                                    ->asArray()->all(), 'study_year_id', 'study_year_id'), ['disabled'=>true]) ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-fees">
                                            <?= $form->field($student, 'reg_fees')->textInput(['disabled'=>true])->label('رسوم التسجيل') ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-fees">
                                            <?= $form->field($student, 'fees')->textInput() ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="mb-3 field-addmission-curr_id">
                                            <?= $form->field($student, 'curr_id')->dropDownList(
                                                \yii\helpers\ArrayHelper::map(\app\models\Currency::find()->where(['hold_id' => 2])
                                                    ->asArray()->all(), 'curr_id', 'curr_name'), ['disabled'=>true]) ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?= Html::submitButton('حفظ', ['class' => 'btn btn-success', 'style' => 'width: 30%;margin-right: 35%;']) ?>

    <?php ActiveForm::end(); ?>

</div>