<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\Addmission */

$this->title = $model->student_name_arabic;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Addmissions'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="addmission-view">

    <div class="row">
        <div class="col-lg-4 col-xl-4">
            <div class="card text-center">
                <div class="card-body">
                    <img src="<?=isset($model->images)?'http://196.202.149.24/api/web/'.$model->images:'/img/users/user.jpg'?>" 
                        width="120px" class="rounded-circle avatar-xla img-thumbnail" alt="profile-image">

                    <h4 class="mb-2"><?=$model->student_name_arabic?></h4>
                    <p class="text-muted mb-2" "=""><?=$model->department->department_name_arabic?></p>
                        <p class=" text-success"><?=$model->un_no?></p>

                    <a href="#"
                        class="btn btn-success btn-xs waves-effect mb-2 waves-light">
                        <i class="ti-email"></i> إرسال رسالة</a>
                    <a href="/student/update?un_no=<?=$model->un_no?>"
                        class="btn btn-pink btn-xs waves-effect mb-2 waves-light">
                        <i class="ti-pencil"></i> تعديل</a>
                </div>
            </div> <!-- end card -->
        </div>
        <div class="col-lg-8 col-xl-8">

        <div class="card">
            <div class="card-body">
                <div class="text-start mt-3">
                    <h4 class="font-13 text-uppercase">البيانات الاساسية :</h4>
                    <p class="text-muted mb-1 font-13"><strong>الرقم الوطني :</strong> 
                        <span class="ms-2"><?=$model->national_number?></span></p>
                    <p class="text-muted mb-2 font-13"><strong>الهاتف :</strong>
                        <span class="ms-2"><?=$model->student_basic_phone?></span></p>
                    <p class="text-muted mb-2 font-13"><strong>البريد :</strong> 
                        <span class="ms-2"><?=$model->student_email?></span></p>
                    <p class="text-muted mb-1 font-13"><strong>العنوان :</strong> 
                        <span class="ms-2"><?=$model->current_student_address?></span></p>
                    <p class="text-muted mb-1 font-13"><strong>الجنسية :</strong> 
                        <span class="ms-2"><?=$model->nationality->nat_name?></span></p>

                    <h4 class="font-13 text-uppercase mt-3">بيانات القبول :</h4>
                    <p class="text-muted mb-2 font-13"><strong>الكلية :</strong> 
                        <span class="ms-2"><?=$model->college->college_name_arabic?></span></p>
                    <p class="text-muted mb-2 font-13"><strong>القسم :</strong> 
                        <span class="ms-2"><?=$model->department->department_name_arabic?></span></p>
                    <p class="text-muted mb-2 font-13"><strong>نوع القبول :</strong> 
                        <span class="ms-2"><?=$model->accept->accept_name?></span></p>
                    <p class="text-muted mb-2 font-13"><strong>عام القبول :</strong> 
                        <span class="ms-2"><?=$model->accept_year?></span></p>

                    <h4 class="font-13 text-uppercase mt-3">البيانات المالية :</h4>
                    <p class="text-muted mb-2 font-13"><strong>رسوم التسجيل :</strong> 
                        <span class="ms-2"><?=isset($reg_fees)?$reg_fees:0?><?=$model->curr->curr_name?></span></p>
                    <p class="text-muted mb-2 font-13"><strong>الرسوم الدراسية :</strong> 
                        <span class="ms-2"><?=$model->fees?><?=$model->curr->curr_name?></span></p>
                </div>
            </div>
        </div>
        </div>
    </div>
</div>