<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\models\Classes;
use app\models\Semester;
use app\models\HoldStatus;
use app\models\Department;
use yii\helpers\ArrayHelper;
use app\models\StudyYear;
/* @var $this yii\web\View */
/* @var $model app\models\Degree */
/* @var $form yii\widgets\ActiveForm */

$this->title = 'قوائم الطلاب الممتحنون';
$this->params['breadcrumbs'][] = $this->title;

$department = app\models\Department::find()->where('hold_id=2')->asArray()->all();
?>
<div class="degree-create panel panel-primary">
    <div class="panel-heading"><h4> قوائم الطلاب الممتحنون</h4></div>
    <div class="panel-body">
        <?php $form = ActiveForm::begin(['options'=>['id'=>'export-form']]); ?>
        <div class="row">
            <div class="col-sm-3">
                <?= $form->field($model, 'dep_id')->dropDownList(
                    ArrayHelper::map($department, 'department_id', 'department_name_arabic'))->label('التخصص');?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($model, 'sem_id')
                    ->dropDownList(
                        ArrayHelper::map(Semester::find()->where(['hold_id'=> 2])
                        ->asArray()->all(), 'semester_id', 'semester_name'))->label('الفصل الدراسي')?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($model, 'year_id')->dropDownList(
                    ArrayHelper::map(StudyYear::find()->where('active = 2')->asArray()->all(), 'study_year_id', 'study_year_name'))->label('العام الدراسي')?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($model, 'exam')->dropDownList(
                    ArrayHelper::map(HoldStatus::find()->where('id<3')->asArray()->all(), 'id', 'try_status'))->label('الدور')?>
            </div>
        </div>
        <div class="form-group">
            <?= Html::submitButton( 'تنزيل', ['class' => 'btn btn-primary', 'style' => 'width: 80%;margin-right: 10%;']) ?>
        </div>
        <?php ActiveForm::end(); ?>
    </div>
</div>