<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\models\Classes;
use app\models\Semester;
use app\models\HoldStatus;
use app\models\Department;
use yii\helpers\ArrayHelper;
use app\models\StudyYear;
use app\models\Subject;


/* @var $this yii\web\View */
/* @var $model app\models\Degree */
/* @var $form yii\widgets\ActiveForm */

$this->title = 'تعديل الدرجات';
$this->params['breadcrumbs'][] = $this->title;

$department = app\models\Department::find()->where('hold_id=2')->asArray()->all();

?>
<div class="degree-create panel panel-primary">
    <div class="panel-heading"><h4> تعديل درجات الطلاب الممتحنون</h4></div>
    <div class="panel-body">
        <?php $form = ActiveForm::begin(['options'=> [ 'id'=>'export-form',
            'options' => ['enctype' => 'multipart/form-data'] ] ]); ?>
        <div class="row">
            <div class="col-sm-4">
                <?= $form->field($model, 'dep_id')->dropDownList(
                    ArrayHelper::map($department, 'department_id', 'department_name_arabic'))->label('التخصص');?>
            </div>
            <div class="col-sm-4">
                <?= $form->field($model, 'sem_id')
                    ->dropDownList(
                        ArrayHelper::map(Semester::find()->where(['hold_id'=> 2])
                        ->asArray()->all(), 'semester_id', 'semester_name'),[
                            'prompt' => 'إختيار الفصل الدراسي',
                            'onchange'=>'
                                $.post( "'.Yii::$app->urlManager->createUrl('data/subjects?semid=').'"+$(this).val()+"&depid="+$("#dynamicmodel-dep_id").val()+"", function( data ) {
                                $( "select#dynamicmodel-sub_id" ).html( data );
                                });'
                        ])->label('الفصل الدراسي')?>
            </div>
            <div class="col-sm-4">
                <?= $form->field($model, 'year_id')->dropDownList(
                    ArrayHelper::map(StudyYear::find()->where('active = 2')->asArray()->all(), 'study_year_id', 'study_year_name'))->label('العام الدراسي')?>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'exam')->dropDownList(
                    ArrayHelper::map(HoldStatus::find()->where('id<3')->asArray()->all(), 'id', 'try_status'))->label('الدور')?>
            </div>
            <div class="col-sm-6">
                <?php $subjectslist =[];
                if(isset($model->dep_id) && isset($model->sem_id)){
                    $subjectslist = ArrayHelper::map(Subject::find()
                        ->where(['dep_id' => $model->dep_id, 'sem_id' => $model->sem_id, 'hold_id' => 2
                            ])->orderBy([ 'order_no' => SORT_ASC, ])->all(), 'sub_id', 'sub_name');
                } 
                echo $form->field($model, 'sub_id')->dropDownList($subjectslist, [
                    'prompt' => 'إختار المادة',])->label('المادة'); ?>
            </div>
        </div>
    </div>
    <div class="form-group">
        <?= Html::submitButton( 'رصد', ['class' => 'btn btn-primary', 'style' => 'width: 500px;margin-right: 210px;']) ?>
    </div>
    <?php ActiveForm::end(); ?>
    </div>

<?php if(\Yii::$app->request->post()) :?>
    
    <?= $this->render('list', ['dataProvider' => $dataProvider, 'subject' => $subject]);?>

<?php endif;?>