<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'التخفيضات');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="disc-type-index">

    <p style="float: left;margin-top: -45px;"><?php if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'create'))
        echo Html::a(Yii::t('app', '<span class=" btn btn-success">+</span>'), ['create'], ['class' => 'link-model-md']); ?></p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'options' => ['class' => 'grid-list-view',],
        'pager' => [
            'class' => \yii\bootstrap5\LinkPager::class
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'id',
            'name',
            'type',
            'd_value',
            'd_from',
            'd_auth',
            'hold.name',
            [
                'class' => ActionColumn::className(),
                'template' => '{update}',
                'urlCreator' => function ($action, app\models\DiscType $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>


</div>
