<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'المهن');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="job-index">

    <p style="float: left;margin-top: -45px;"><?php if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'create'))
        echo Html::a(Yii::t('app', '<span class=" btn btn-success">+</span>'), ['create'], ['class' => 'link-model-md']); ?></p>

    <?php Pjax::begin(); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'options' => ['class' => 'grid-list-view',],
        'pager' => [
            'class' => \yii\bootstrap5\LinkPager::class
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'job_id',
            'job_name',
            // 'cla_job_id',
            'fees1',
            'fees2',
            [
                'attribute' => 'hold_id',
                'value' => 'hold.name',
                'label' => 'الحالة',
            ],
            [
                'class' => ActionColumn::className(),
                'template' => '{update} {delete}',
                'urlCreator' => function ($action, \app\models\Job $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'job_id' => $model->job_id]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
