<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel app\models\PaymentSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'الإيصالات المالية');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="payment-index">

<?php Pjax::begin(); ?>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        // 'summary' => '',
        'options' => ['class' => 'grid-list-view',],
        'layout' => '{items}<nav>{pager}</nav>',
        'pager' => [
            'class' => \yii\bootstrap5\LinkPager::class
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'un_no',
            'esal_no',
            [
                'attribute' => 'year_id',
                'filter'=> \yii\helpers\ArrayHelper::map(app\models\StudyYear::find()->where('study_year_id!=0')->all(), 'study_year_id','study_year_id'),
            ],
            [
                'attribute' => 'esal_date',
                'filter' => false,
            ],
            [
                'attribute' => 'curr_id',
                'value' => 'curr.curr_name',
                'filter' => false,
            ],
            [
                'attribute' => 'amount',
                'filter' => false,
            ],
            [
                'attribute' => 'bank_id',
                'value' => 'bank.bank_name',
                // 'filter' => false,
                'filter'=> \yii\helpers\ArrayHelper::map(app\models\Bank::find()->where('hold_id=2')->all(), 'bank_id','bank_name'),
            ],
            [
                'class' => ActionColumn::className(),
                'template' => '{update} {view}',
                'buttons' =>[
                    'view' => function($url, $model){
                        return Html::a('<i class="fa fa-eye fa-lg" aria-hidden="true"></i>', $url, [
                                    'class' => 'link-model-lg']);
                    },
                    'update' => function($url, $model){
                        if($model->bank_id==4)
                            return Html::a('<i class="fa fa-pencil fa-lg" aria-hidden="true"></i>', $url, [
                                'class' => 'link-model-lg']); else return '';
                    }
                ],
                'urlCreator' => function ($action, \app\models\Payment $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'esal_no' => $model->esal_no]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
