<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\Addmission */

$this->title = $model->student_name_arabic;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Addmissions'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
$attachments = \app\models\StdAttachment::find()->where(['un_no' => $model->un_no])->all();
?>
<div class="addmission-view">
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">القبول و التسجيل</a></li>
                        <li class="breadcrumb-item active"><?=$model->student_name_arabic?></li>
                    </ol>
                </div>
                <h4 class="page-title">ملف الطالب</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-lg-4 col-xl-4">
            <div class="card text-center">
                <div class="card-body">
                    <img src="<?=isset($model->images)?'http://196.202.149.24/api/web/'.$model->images:'/img/users/user.jpg'?>" 
                        width="120px" class="rounded-circle avatar-xla img-thumbnail" alt="profile-image">

                    <h4 class="mb-2"><?=$model->student_name_arabic?></h4>
                    <p class="text-muted mb-2" "=""><?=$model->department->department_name_arabic?></p>
                        <p class=" text-success"><?=$model->un_no?></p>

                    <a href="#"
                        class="btn btn-success btn-xs waves-effect mb-2 waves-light">
                        <i class="ti-email"></i> إرسال رسالة</a>
                    <a href="/previews/update?un_no=<?=$model->un_no?>"
                        class="btn btn-pink btn-xs waves-effect mb-2 waves-light">
                        <i class="ti-pencil"></i> تعديل</a>
                </div>
            </div> <!-- end card -->
        </div>
        <div class="col-lg-8 col-xl-8">

            <div class="card">
                <div class="card-body">
                    <div class="text-start mt-3">
                        <h4 class="font-13 text-uppercase">البيانات الاساسية :</h4>
                        <p class="text-muted mb-1 font-13"><strong>الرقم الوطني :</strong> 
                            <span class="ms-2"><?=$model->national_number?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>الهاتف :</strong>
                            <span class="ms-2"><?=$model->student_basic_phone?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>البريد :</strong> 
                            <span class="ms-2"><?=$model->student_email?></span></p>
                        <p class="text-muted mb-1 font-13"><strong>العنوان :</strong> 
                            <span class="ms-2"><?=$model->current_student_address?></span></p>
                        <p class="text-muted mb-1 font-13"><strong>الجنسية :</strong> 
                            <span class="ms-2"><?=$model->nationality->nat_name?></span></p>

                        <h4 class="font-13 text-uppercase mt-3">بيانات القبول :</h4>
                        <p class="text-muted mb-2 font-13"><strong>الكلية :</strong> 
                            <span class="ms-2"><?=$model->college->college_name_arabic?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>القسم :</strong> 
                            <span class="ms-2"><?=$model->department->department_name_arabic?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>نوع القبول :</strong> 
                            <span class="ms-2"><?=$model->accept->accept_name?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>عام القبول :</strong> 
                            <span class="ms-2"><?=$model->accept_year?></span></p>

                        <h4 class="font-13 text-uppercase mt-3">البيانات المالية :</h4>
                        <p class="text-muted mb-2 font-13"><strong>رسوم التسجيل :</strong> 
                            <span class="ms-2"><?=isset($reg_fees)?$reg_fees:0?><?=$model->curr->curr_name?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>الرسوم الدراسية :</strong> 
                            <span class="ms-2"><?=$model->fees?><?=$model->curr->curr_name?></span></p>
                    </div>
                </div>
            </div>
            <?php if($attachments){ ?>
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3">
                        <i class="icon-folder-alt me-1"></i> الملفات المرفقة
                    </h4>
                    <div>
                        <table class="table table-borderless table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>اسم الملف</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($attachments as $att){?>
                                <tr>
                                    <td>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                            stroke-width="2" stroke-linecap="round"
                                            stroke-linejoin="round"
                                            class="feather feather-image icon-dual">
                                            <rect x="3" y="3" width="18" height="18" rx="2" ry="2">
                                            </rect>
                                            <circle cx="8.5" cy="8.5" r="1.5"></circle>
                                            <polyline points="21 15 16 10 5 21"></polyline>
                                        </svg>
                                        <span class="ms-2 fw-semibold">
                                            <a href="javascript: void(0);" class="text-reset"><?=$att->note?> 
                                                <span class="badge badge-soft-blue"><?=$att->ext?></span></a>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group dropdown">
                                            <a class="table-action-btn dropdown-toggle arrow-none btn btn-light btn-xs"
                                                data-bs-toggle="dropdown" aria-expanded="false"><i
                                                    class="mdi mdi-dots-horizontal"></i></a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a class="dropdown-item" href="http://196.202.149.24/api/web/<?=$att->url?>">
                                                    <i class="mdi mdi-download me-2 text-muted vertical-middle"></i>تحميل</a>
                                                <a class="dropdown-item" href="#">
                                                    <i class="mdi mdi-delete me-2 text-muted vertical-middle"></i>حذف</a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div><?php } ?>
        </div>
    </div>
</div>