<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\RegFeesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'إدارة رسوم التسجيل');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="reg-fees-index">

    <p style="float: left;margin-top: -45px;"><?php if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'create'))
        echo Html::a(Yii::t('app', '<span class=" btn btn-success">+</span>'), ['create'], ['class' => 'link-model-md']); ?></p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'options' => ['class' => 'grid-list-view',],
        'pager' => [
            'class' => \yii\bootstrap5\LinkPager::class
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'id',
            [
                'attribute' => 'dep_id',
                'value' => 'dep.department_name_arabic',
                'filter' => \yii\helpers\ArrayHelper::map(app\models\Department::find()->where('hold_id=2')->all(), 'department_id','department_name_arabic'),
            ],
            [
                'attribute' => 'acc_id',
                'value' => 'acc.accept_name',
                'filter' => \yii\helpers\ArrayHelper::map(app\models\AcceptType::find()->where('hold_id=2')->all(), 'accept_id','accept_name'),
            ],
            [
                'attribute' => 'year_id',
                'value' => 'year.study_year_name',
                'filter' => \yii\helpers\ArrayHelper::map(app\models\StudyYear::find()->where('hold_id=2 AND open_acc=2')->all(), 'study_year_id','study_year_name'),
            ],
            [
                'attribute' => 'curr_id',
                'value' => 'curr.curr_name',
                'filter' => \yii\helpers\ArrayHelper::map(app\models\Currency::find()->where('hold_id=2')->all(), 'curr_id','curr_name'),
            ],
            [
                'attribute' => 'reg_fees',
                'filter' => false,
            ],
            [
                'class' => ActionColumn::className(),
                'template' => '{update}',
                'urlCreator' => function ($action, \app\models\RegFees $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>


</div>
