<?php

/* @var $this yii\web\View */
/* @var $form yii\bootstrap5\ActiveForm */
/* @var $model \app\models\LoginForm */

use yii\bootstrap5\Html;
use yii\bootstrap5\ActiveForm;

$this->title = 'تسجيل الدخول';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="row justify-content-center">
    <div class="col-md-8 col-lg-6 col-xl-4">
        <div class="card">

            <div class="card-body p-4">
                
                <div class="text-center">
                    <div class="auth-logo">
                        <div href="index.html" class="logo text-center">
                            <div class="d-flex">
                                <img class="me-2" src="<?=Yii::$app->homeUrl?>img/oiu-logo.png" alt="" height="50">
                                <div class="font-20 text-start">
                                    <b>جامعة ------</b><br>
                                    <small class=""><b>النظام الاكاديمي</b></small>
                                </div>
                            </div>
                        </div>                
                    </div>
                    <hr/>
                    <p class="text-muted mb-4 mt-3 small">قم بادخال اسم المستخدم و كلمة المرور للدخول  للنظام</p>
                </div>

                <?php $form = ActiveForm::begin(['id' => 'login-form']); ?>

                    <div class="mb-3">
                        <?= $form->field($model, 'username')->textInput(['autofocus' => true, 'placeHolder' => 'اسم المستخدم']) ?>
                        <!-- <input class="form-control" type="email" required="" placeholder="البريد الالكتروني"> -->
                    </div>

                    <div class="mb-3">
                        <label for="password" class="form-label">كلمة المرور</label>
                        <div class="input-group input-group-merge">
                            <input type="password" class="form-control"id="loginform-password"name="LoginForm[password]" placeholder="كلمة المرور">
                            <div class="input-group-text" data-password="false">
                                <span class="password-eye"></span>
                            </div>
                        </div>
                    </div>                                    
                    <hr/>
                    <div class="text-center d-grid">
                        <?= Html::submitButton('<i class="fe-log-in"></i> دخول', ['class' => 'btn btn-info', 'name' => 'login-button']) ?>
                    </div>

                <?php ActiveForm::end(); ?>
                
            </div> <!-- end card-body -->
        </div>
        <!-- end card -->

        <div class="row mt-3">
            <div class="col-12 text-center">
                <p><a class="nav-link" href="<?=Yii::$app->homeUrl?>site/request-password-reset">Password Reset</a></p>
                <p class="text-white-50">تواصل معنا  <a href="auth-register.html" class="text-white ms-1"><b>الدعم الفني</b></a></p>
            </div> <!-- end col -->
        </div>
        <!-- end row -->

    </div> <!-- end col -->
</div>