<?php

use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\StudentSearch */
/* @var $form yii\widgets\ActiveForm */

?>

<div class="student-search">

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <?php $form = ActiveForm::begin([
                        'action' => ['index'],
                        'method' => 'get',
                        'options' => [
                            'data-pjax' => 1
                        ],
                    ]); ?>
                    <div class="row justify-content-between">
                        <div class="col-auto">
                            <div class="d-flex flex-wrap align-items-center">
                                <label for="status-select" class="me-2">بحث عن طريق </label>
                                <div class="me-3">
                                    <?= $form->field($model, 'un_no')->textInput(['placeholder' => 'الرقم الجامعي'])->label(false) ?>
                                </div>
                                <div class="me-3">
                                    <?= $form->field($model, 'f_name_ar')->textInput(['placeholder' => 'الاسم الأول'])->label(false) ?>
                                </div> 
                            </div>
                        </div>
                        <div class="col-auto">
                            <div class="text-lg-end my-1 my-lg-0">
                                <?= Html::submitButton(Yii::t('app', '<i class="ti-search"></i> يحث'), ['class' => 'btn btn-success']) ?>
                                <div class="btn-group me-2">
                                    <a href="<?=Yii::getAlias('@web')?>/student/stuview?id=1" class="btn waves-effect waves-light 
                                    <?=isset(Yii::$app->user->identity->profile)?(Yii::$app->user->identity->profile->student_view==1?'btn-secondary':'btn-light'):'btn-secondary'?> "><i class="mdi mdi-apps"></i></a>
                                    <a href="<?=Yii::getAlias('@web')?>/student/stuview?id=2" class="btn waves-effect waves-light 
                                    <?=isset(Yii::$app->user->identity->profile)?(Yii::$app->user->identity->profile->student_view==1?'btn-light':'btn-secondary'):'btn-light'?>"><i class="mdi mdi-format-list-bulleted-type"></i></a>
                                </div>
                                
                            </div>
                        </div><!-- end col-->
                    </div><!-- end row -->
                    <?php ActiveForm::end(); ?>
                </div>
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
</div>