<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $model app\models\StudentInfo */

$this->title = Yii::t('app', 'الطالب');
$this->params['breadcrumbs'][] = $this->title;
if($student){
    $reg_fees = \Yii::$app->db->createCommand('SELECT getregfees('. 
        $student[0]->un_no .') as regfees')->queryOne()['regfees'];
    $attachments = \app\models\StdAttachment::find()->where(['un_no' => $student[0]->un_no])->all();
?>
<div class="student-info-view"style="direction: rtl;">
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">القبول و التسجيل</a></li>
                        <li class="breadcrumb-item active"><?=$student[0]->unNo->student_name_arabic?></li>
                    </ol>
                </div>
                <h4 class="page-title">ملف الطالب</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-lg-4 col-xl-4">
            <div class="card text-center">
                <div class="card-body">
                    <!-- <img src="<?=isset($student[0]->unNo->images)?$student[0]->unNo->images:'/img/users/user.jpg'?>" 
                        width="120px" class="rounded-circle avatar-xla img-thumbnail" alt="profile-image"> -->
                    <img src="<?=isset($student[0]->unNo->images)?'http://196.202.149.24/api/web/'.$student[0]->unNo->images:'/img/users/user.jpg'?>" 
                        width="120px" class="rounded-circle avatar-xla img-thumbnail" alt="profile-image">

                    <h4 class="mb-2"><?=$student[0]->unNo->student_name_arabic?></h4>
                    <p class="text-muted mb-2" "=""><?=$student[0]->unNo->department->department_name_arabic?></p>
                        <p class=" text-success"><?=$student[0]->un_no?></p>

                    <a href="#"
                        class="btn btn-success btn-xs waves-effect mb-2 waves-light">
                        <i class="ti-email"></i> إرسال رسالة</a>
                    <a href="/student/update?un_no=<?=$student[0]->un_no?>"
                        class="btn btn-pink btn-xs waves-effect mb-2 waves-light">
                        <i class="ti-pencil"></i> تعديل</a>

                    <div class="text-start mt-3">
                        <h4 class="font-13 text-uppercase">البيانات الاساسية :</h4>
                        <p class="text-muted mb-1 font-13"><strong>الرقم الوطني :</strong> <span
                                class="ms-2"><?=$student[0]->unNo->national_number?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>الهاتف :</strong><span
                                class="ms-2"><?=$student[0]->unNo->student_basic_phone?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>البريد :</strong> <span
                                class="ms-2"><?=$student[0]->unNo->student_email?></span></p>
                        <p class="text-muted mb-1 font-13"><strong>العنوان :</strong> <span
                                class="ms-2"><?=$student[0]->unNo->current_student_address?></span></p>
                        <p class="text-muted mb-1 font-13"><strong>الجنسية :</strong> <span
                                class="ms-2"><?=$student[0]->unNo->nationality->nat_name?></span></p>

                        <h4 class="font-13 text-uppercase mt-3">بيانات القبول :</h4>
                        <p class="text-muted mb-2 font-13"><strong>الكلية :</strong> <span
                                class="ms-2"><?=$student[0]->unNo->college->college_name_arabic?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>القسم :</strong> <span
                                class="ms-2"><?=$student[0]->unNo->department->department_name_arabic?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>نوع القبول :</strong> <span
                                class="ms-2"><?=$student[0]->unNo->accept->accept_name?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>عام القبول :</strong> <span
                                class="ms-2"><?=$student[0]->unNo->accept_year?></span></p>

                        <h4 class="font-13 text-uppercase mt-3">البيانات المالية :</h4>
                        <p class="text-muted mb-2 font-13"><strong>رسوم التسجيل :</strong> <span
                                class="ms-2"><?=isset($reg_fees)?$reg_fees:0?>
                                <?=$student[0]->unNo->curr->curr_name?></span></p>
                        <p class="text-muted mb-2 font-13"><strong>الرسوم الدراسية :</strong> <span
                                class="ms-2"><?=$student[0]->unNo->fees?>
                                <?=$student[0]->unNo->curr->curr_name?></span></p>
                    </div>

                </div>
            </div> <!-- end card -->


            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-0">مجاميع مالية</h4>
                    <div class="widget-chart text-center" dir="ltr">
                        <div id="total-revenue" class="mt-0" data-colors="#f86262"></div>
                        <p class="text-muted mt-0 text-center">مجموع المبلغ للعام 2021-2022</p>
                        <h2>
                            <span>170000</span><br>
                            <small>جنيه</small>
                        </h2>
                        <p class="text-muted w-75 mx-auto sp-line-2">عبارة عن رسوم التسجيل و الرسوم
                            الدراسية لعام
                            واحد.</p>
                        <div class="row mt-3">
                            <div class="col-6">
                                <p class="text-muted font-15 mb-1 text-truncate">المتبقي</p>
                                <h4><i class="fe-arrow-down text-danger me-1"></i>75000
                                </h4>
                            </div>
                            <div class="col-6">
                                <p class="text-muted font-15 mb-1 text-truncate">المدفوع</p>
                                <h4><i class="fe-arrow-up text-success me-1"></i>95000</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div> <!-- end card -->

        </div> <!-- end col-->

        <div class="col-lg-8 col-xl-8">

            <div class="card">
                <div class="card-body">
                <div class="float-end d-none d-md-inline-block">
                        <div class="btn-group mb-2">
                            <button type="button" class="btn btn-light"><i class="dripicons-print"></i>
                                طباعة </a></button>
                            <button type="button" class="btn btn-secondary"><i class="ti-hand-open"></i>
                                اذن تحصيل</button>
                        </div>
                    </div>
                    <h4 class="header-title mb-3">
                        <i class="icon-directions me-1"></i> النشاط الادكاديمي
                    </h4>
                    <div>
                        <table class="table table-borderless table-hover table-striped mb-0">
                            <thead class="table-lighat">
                                <tr>
                                    <th></th>
                                    <th>الفرقة</th>
                                    <th>الموقف الاكاديمي</th>
                                    <th>هل تم التسجيل؟</th>
                                    <th>الإجراءات</th>
                                    <th>التخفيضات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $x=0; foreach($student as $stu){ $x++; 
                                    $proc = \app\models\StudentProc::find()->where(['student_id' => $stu->id])->all();
                                    $disc = \app\models\StudentDisc::find()->where(['student_id' => $stu->id])->all();?>
                                    <tr>
                                        <td><?=$x?></td>
                                        <td>
                                            <b><?=$stu->class->class_name_arabic?></b><br />
                                            <span class="blockquote-footer"><?=$stu->studyYear->study_year_name?></span>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?=$stu->previous_academic_status_id==1?'success':
                                                ($stu->previous_academic_status_id==4?'danger':'warning')?>">
                                                <?=$stu->previousAcademicStatus->academic_status_name?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="text-<?=$stu->is_reg==1?'danger':'success'?>">
                                                <i class="mdi mdi-checkbox-blank-circle <?=$stu->is_reg==1?'':'text-success'?>"></i>
                                                <?=$stu->is_reg==1?'غير مسجل':'مسجل'?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if($proc){ foreach($proc as $p){?>
                                                <?=$p->status_id?> - <a href="<?=$p->fileimage?>">تحميل</a><br />
                                            <?php } }else{echo '-';}?>
                                        </td>
                                        <td>
                                            <?php if($disc){ foreach($disc as $d){?>
                                                <?=$d->discType->name?> (<?=$d->disc?>
                                                <?=$d->discType->type==1?'%':''?>) 
                                                - <a href="<?=$d->fileimage?>">تحميل</a><br />
                                            <?php } }else{echo '-';}?>
                                        </td>
                                        <!-- <td><?=$stu->created_date?></td> -->
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <?php if($payment){?>
                <div class="card">
                    <div class="card-body">
                        
                        <h4 class="header-title mb-3">
                            <i class="mdi mdi-cards-variant me-1"></i> الايصالات المالية
                        </h4>
                        <div>
                            <table class="table table-borderless table-hover table-striped mb-0">
                                <thead class="">
                                    <tr>
                                        <th></th>
                                        <th>الفرقة</th>
                                        <th>رقم الايصال</th>
                                        <th>المجموع</th>
                                        <th>العملة</th>
                                        <th>تفاصيل المبلغ</th>
                                        <th>تاريخ الايصال</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $x=0; $sum=0; foreach($payment as $pay){ $x++; $sum+=$pay->amount; ?>
                                        <tr>
                                            <td><?=$x?></td>
                                            <td>
                                                <b><?=$pay->cla_id?></b><br>
                                                <span class="blockquote-footer"><?=$pay->year->study_year_name?></span>
                                            </td>
                                            <td><?=$pay->esal_no?></td>
                                            <td><b class="text-dark"><?=$pay->amount?></b></td>
                                            <td>
                                                <span class="badge badge-soft-<?=$pay->curr_id==0?'success text-success':'danger text-danger'?> p-1">
                                                <?=$pay->curr->curr_name?>
                                                </span>
                                            </td>
                                            <td>
                                                <div class="text-blue">
                                                    <b><?=$pay->reg_fees?></b>
                                                    <span class="badge badge-soft-blue">تسجيل</span>
                                                </div>
                                                <div class="text-info">
                                                    <b><?=$pay->study_fees?></b>
                                                    <span class="badge badge-soft-info">قسط</span>
                                                </div>
                                                <div class="text-warning">
                                                    <b><?=$pay->late_fees?></b>
                                                    <span class="badge badge-soft-warning">متاخرات</span>
                                                </div>
                                                <div class="text-danger">
                                                    <b><?=$pay->fine_fees?></b>
                                                    <span class="badge badge-soft-danger">غرامة</span>
                                                </div>
                                            </td>
                                            <td><?=$pay->esal_date?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="7">
                                            <div class="text-end">
                                                <hr>
                                                <b>العدد الايصالات :<?=$x?></b>
                                                <h4>المجموع : <?=$sum?></h4>
                                            </div>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            <?php } if($attachments){ ?>
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3">
                        <i class="icon-folder-alt me-1"></i> الملفات المرفقة
                    </h4>
                    <div>
                        <table class="table table-borderless table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>اسم الملف</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($attachments as $att){?>
                                <tr>
                                    <td>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                            stroke-width="2" stroke-linecap="round"
                                            stroke-linejoin="round"
                                            class="feather feather-image icon-dual">
                                            <rect x="3" y="3" width="18" height="18" rx="2" ry="2">
                                            </rect>
                                            <circle cx="8.5" cy="8.5" r="1.5"></circle>
                                            <polyline points="21 15 16 10 5 21"></polyline>
                                        </svg>
                                        <span class="ms-2 fw-semibold">
                                            <a href="javascript: void(0);" class="text-reset"><?=$att->note?> 
                                                <span class="badge badge-soft-blue"><?=$att->ext?></span></a>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group dropdown">
                                            <a class="table-action-btn dropdown-toggle arrow-none btn btn-light btn-xs"
                                                data-bs-toggle="dropdown" aria-expanded="false"><i
                                                    class="mdi mdi-dots-horizontal"></i></a>
                                            <div class="dropdown-menu dropdown-menu-end">
                                                <a class="dropdown-item" href="http://196.202.149.24/api/web/<?=$att->url?>">
                                                    <i class="mdi mdi-download me-2 text-muted vertical-middle"></i>تحميل</a>
                                                <a class="dropdown-item" href="#">
                                                    <i class="mdi mdi-delete me-2 text-muted vertical-middle"></i>حذف</a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div><?php } ?>
            <!-- <div class="card">
                <div class="card-body">   
                    <h4 class="header-title mb-3">
                        <i class="icon-calender me-1"></i> السجلات التاريخية
                    </h4>
                    
                    <div class="border rounded mt-4 mb-4">
                        <form action="#" class="comment-area-box">
                            <textarea rows="3" class="form-control border-0 resize-none" placeholder="كتابة ملاحظة"></textarea>
                            <div class="p-2 bg-light d-flex justify-content-between align-items-center">
                                <button type="submit" class="btn btn-sm btn-success"><i class="mdi mdi-send me-1"></i>ارسال</button>
                            </div>
                        </form>
                    </div> <!-- end .border-->

                </div>
            </div> -->
            <!-- end row -->

        </div> <!-- container -->

    </div>
</div>
<?php } else echo 'عفواً الطالب غير مقيد بفرقة'; ?>