<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'إدارة العام الدراسي');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="study-year-index">

    <p style="float: left;margin-top: -45px;"><?php if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'create'))
        echo Html::a(Yii::t('app', '<span class=" btn btn-success">+</span>'), ['create'], ['class' => 'link-model-md']); ?></p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'options' => ['class' => 'grid-list-view',],
        'pager' => [
            'class' => \yii\bootstrap5\LinkPager::class
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'study_year_id',
            'study_year_name',
            [
                'attribute' => 'active',
                'value' => 'active0.name',
                'label' => 'تنشيط العام',
            ],
            [
                'attribute' => 'open_acc',
                'value' => 'openAcc.name',
                'label' => 'فتح القبول',
            ],
            [
                'attribute' => 'hold_id',
                'value' => 'hold.name',
                'label' => 'الحالة',
            ],
            [
                'class' => ActionColumn::className(),
                'template' => '{update}',
                'urlCreator' => function ($action, \app\models\StudyYear $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'study_year_id' => $model->study_year_id]);
                 }
            ],
        ],
    ]); ?>


</div>
