<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel app\models\SubjectSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'المواد');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="subject-index">

    <p style="float: left;margin-top: -45px;"><?= Html::a('<span class=" btn btn-success">+</span>', ['subject/create'], ['class' => 'link-model-md']);?></p>


    <?php Pjax::begin();

    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'options' => ['class' => 'grid-list-view',],
        // 'layout' => '{items}<nav>{pager}</nav>',
        'pager' => [
            'class' => \yii\bootstrap5\LinkPager::class
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'sub_id',
            [
                'attribute' => 'dep_id',
                'value' => 'dep.department_name_arabic',
                'label' => 'التخصص',
                'filter' => false,
            ],
            [
                'attribute' => 'sem_id',
                'value' => 'sem.semester_name',
                'label' => 'الفصل الدراسي',
                'filter' => false,
            ],
            [
                'attribute' => 'sub_type',
                'value' => 'subType.name',
                'label' => 'نوع المادة',
                'filter' => false,
            ],
            'sub_name',
            [
                'attribute' => 'hold_id',
                'value' => 'hold.name',
                'label' => 'الحالة',
                'filter' => false,
            ],
            [
                'class' => ActionColumn::className(),
                'template' => '{update}',
                'urlCreator' => function ($action, app\models\Subject $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'sub_id' => $model->sub_id]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
