<?php

use app\models\Controllers;
use app\models\HoldStatus;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use app\models\Actions;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\UserGroup */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="user-group-form">

    <?php $form = ActiveForm::begin(['id' => 'dynamic-form']); ?>
    <div class="student-search">
        <div class="row">
            <div class="col-lg-6"><?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?></div>
            <div class="col-lg-6"><?= $form->field($model, 'name_en')->textInput(['maxlength' => true]) ?></div>
        </div>
    </div>
    <?php if($roles){ ?>
        <div class="student-search">
            <div class="panel panel-default">
                <div class="panel-heading"><h4 style="text-align: center;">
                    صلاحيات المجموعة - <?=$roles[0]->group->name?></h4></div>
                <div class="panel-body">
                    <?php \wbraganca\dynamicform\DynamicFormWidget::begin([
                        'widgetContainer' => 'dynamicform_wrapper', // required: only alphanumeric characters plus "_" [A-Za-z0-9_]
                        'widgetBody' => '.container-items', // required: css class selector
                        'widgetItem' => '.item', // required: css class
                        // 'limit' => 4, // the maximum times, an element can be cloned (default 999)
                        // 'min' => 1, // 0 or 1 (default 1)
                        'insertButton' => '.add-item', // css class
                        'deleteButton' => '.remove-item', // css class
                        'model' => $roles[0],
                        'formId' => 'dynamic-form',
                        'formFields' => [
                            // 'user_role_id',
                            'controller',
                            'action',
                        ],
                    ]); ?>

                    <div class="container-items"><!-- widgetContainer -->
                        <?php foreach ($roles as $i => $role): ?>
                            <div class="item panel panel-default"><!-- widgetBody -->
                                <div class="panel-heading">
                                    <div class="pull-right"style="float: left;margin-left: 10px;">
                                        <button type="button" class="add-item btn btn-success btn-xs">+</button>
                                        <button type="button" class="remove-item btn btn-danger btn-xs">-</button>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>
                                <div class="panel-body"style="margin: 0px 10px;">
                                    <?=Html::activeHiddenInput($role, "[{$i}]id");?>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <?= $form->field($role, "[{$i}]controller")->dropDownList(
                                                ArrayHelper::map(Controllers::find()->asArray()->all(), 'id', 'name'))?>
                                        </div>
                                        <div class="col-sm-6">
                                            <?= $form->field($role, "[{$i}]action")->dropDownList(
                                                ArrayHelper::map(Actions::find()->asArray()->all(), 'id', 'name')) ?>
                                        </div>
                                    </div><!-- .row -->
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <?php \wbraganca\dynamicform\DynamicFormWidget::end(); ?>
                </div>
            </div>
        </div>
    <?php } ?>
    <div class="form-group">
        <?= Html::submitButton('حفظ', ['class' => 'btn btn-success', 'style' => 'width: 30%;margin-right: 35%;']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
