<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel backend\models\UserSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'المستخدمين');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="user-index">
    <?php if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'create-user')){?>
    <p><?= Html::a('<span class=" btn btn-success">+</span>', ['user/create-user'], ['class' => 'link-model-lg']);?></p>
    <?php 
    } 
    Pjax::begin(); 
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'summary' => '',
        'options' => ['class' => 'grid-list-view',],
        'layout' => '{items}<nav>{pager}</nav>',
        'rowOptions' => function($model){
            if($model->hold_id==1){return ['class'=> 'table-danger', 'style' => '--ct-table-striped-color: #000;'];}
            else{return ['class'=> 'table-success', 'style' => '--ct-table-striped-color: #000;'];}
        },
        'pager' => [
            'class' => \yii\bootstrap5\LinkPager::class
        ],
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'username',
            'email:email',
            [
                'attribute' => 'id',
                'label' => 'الصلاحية',
                'filter' => false,
                'value' => function($model){
                    $userrole = \app\models\UserRols::find()
                        ->where(['user_id' => $model->id, 'hold_id' => 2])->one();
                    if($userrole) return $userrole->group->name; else return '-';
                },
            ],
            [
                'attribute' => 'created_at',
                'value' => function($data){ return Yii::$app->formatter->asDate($data->created_at,'d-m-Y');},
                'filter' => false,
            ],
            [
                'attribute' => 'updated_at',
                'value' => function($data){ return Yii::$app->formatter->asDate($data->updated_at,'d-m-Y');},
                'filter' => false,
            ],
            [
                'class' => ActionColumn::className(),
                'template' => '{update} {updatestatus} {log}',
                'buttons' =>[
                    'updatestatus' => function($url, $model){
                        if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'updatestatus')){
                            if($model->hold_id==1)
                                return Html::a('<li class="fa fa-lock-open"></li>', $url);
                            else return Html::a('<li class="fa fa-unlock"></li>', $url);
                        }
                    },
                    'log' => function($url, $model){
                        if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'log')){
                        return Html::a('log', $url);}},
                    'update' => function($url, $model){
                        if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'update-user')){
                            return Html::a('<i class="fas fa-pencil-alt"></i>', $url);}
                    }
                ],
                'urlCreator' => function ($action, $model, $key, $index, $column) {
                    // return Url::toRoute([$action, 'id' => $model->id]);
                    if ($action === 'update') {
                        return Url::to(['user/update-user', 'id' => $model->id]);
                    }if ($action === 'updatestatus') {
                        return Url::to(['user/update-user-status', 'user_id' => $model->id]);
                    }if ($action === 'log') {
                        return Url::to(['user/log', 'user_id' => $model->id]);
                    }
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
