<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel backend\models\ValueDistSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'إدارة نسب التوزيع');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="value-dist-index">
    <p style="float: left;margin-top: -45px;"><?php if(Yii::$app->Authentication->isAllow(Yii::$app->controller->id, 'create'))
            echo Html::a(Yii::t('app', '<span class=" btn btn-success">+</span>'), ['create'], ['class' => 'link-model-lg']); ?></p>

    <?php Pjax::begin(); ?>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'id',
            
            [
                'attribute' => 'year_id',
                'value' => 'year.study_year_name',
                // 'label' => 'الكلية',
                'filter' => \yii\helpers\ArrayHelper::map(\app\models\StudyYear::find()->where(['hold_id' => 2])
                ->asArray()->all(), 'study_year_id', 'study_year_id'),
            ],
            [
                'attribute' => 'dis_type',
                'value' => function($data){ return $data->dis_type==1?'عام':'خاص';},
                'filter' => false,
            ],
            [
                'attribute' => 'coll_id',
                'value' => 'coll.college_name_arabic',
                'label' => 'الكلية',
                'filter' => \yii\helpers\ArrayHelper::map(\app\models\College::find()->where(['hold_id' => 2])
                ->asArray()->all(), 'college_id', 'college_name_arabic'),
            ],
            [
                'attribute' => 'acc_id',
                'value' => 'acc.acc_name',
                'label' => 'الحساب',
                'filter' => \yii\helpers\ArrayHelper::map(\app\models\Account::find()->where(['hold_id' => 2])
                ->asArray()->all(), 'acc_id', 'acc_name'),
            ],
            [
                'attribute' => 'fees_id',
                'value' => 'fees.fees_name',
                'label' => 'نوع الرسوم',
                'filter' => false,
            ],
            [
                'attribute' => 'value',
                'filter' => false,
            ],
            [
                'attribute' => 'fees_v',
                'filter' => false,
            ],
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\models\ValueDist $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
